/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryChangeQuantityActionBuilder;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntrySetExpectedDeliveryActionBuilder;
import com.commercetools.api.models.inventory.InventoryEntrySetRestockableInDaysActionBuilder;
import com.commercetools.api.models.inventory.InventoryEntrySetSupplyChannelActionBuilder;
import com.commercetools.api.models.inventory.InventoryEntryUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;

public final class InventoryUpdateActionUtils {
    @Nonnull
    public static Optional<InventoryEntryUpdateAction> buildChangeQuantityAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        Long oldQuantityOnStock = oldEntry.getQuantityOnStock();
        Long newQuantityOnStock = newEntry.getQuantityOnStock() == null ? NumberUtils.LONG_ZERO : newEntry.getQuantityOnStock();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldQuantityOnStock, newQuantityOnStock, () -> InventoryEntryChangeQuantityActionBuilder.of().quantity(newQuantityOnStock).build());
    }

    @Nonnull
    public static Optional<InventoryEntryUpdateAction> buildSetRestockableInDaysAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        Long oldRestockableInDays = oldEntry.getRestockableInDays();
        Long newRestockableInDays = newEntry.getRestockableInDays();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldRestockableInDays, newRestockableInDays, () -> InventoryEntrySetRestockableInDaysActionBuilder.of().restockableInDays(newRestockableInDays).build());
    }

    @Nonnull
    public static Optional<InventoryEntryUpdateAction> buildSetExpectedDeliveryAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        ZonedDateTime oldExpectedDelivery = oldEntry.getExpectedDelivery();
        ZonedDateTime newExpectedDelivery = newEntry.getExpectedDelivery();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldExpectedDelivery, newExpectedDelivery, () -> InventoryEntrySetExpectedDeliveryActionBuilder.of().expectedDelivery(newExpectedDelivery).build());
    }

    @Nonnull
    public static Optional<InventoryEntryUpdateAction> buildSetSupplyChannelAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        ChannelReference oldSupplyChannel = oldEntry.getSupplyChannel();
        ChannelResourceIdentifier newSupplyChannel = newEntry.getSupplyChannel();
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldSupplyChannel, newSupplyChannel, () -> InventoryEntrySetSupplyChannelActionBuilder.of().supplyChannel(newSupplyChannel).build());
    }

    private InventoryUpdateActionUtils() {
    }
}

