/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.BaseSyncOptionsBuilder;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import javax.annotation.Nonnull;

public final class ProductSyncOptionsBuilder
extends BaseSyncOptionsBuilder<ProductSyncOptionsBuilder, ProductSyncOptions, ProductProjection, ProductDraft, ProductUpdateAction> {
    public static final int BATCH_SIZE_DEFAULT = 30;
    private SyncFilter syncFilter;
    static final boolean ENSURE_CHANNELS_DEFAULT = false;
    private boolean ensurePriceChannels = false;

    private ProductSyncOptionsBuilder(ProjectApiRoot ctpClient) {
        this.ctpClient = ctpClient;
    }

    public static ProductSyncOptionsBuilder of(@Nonnull ProjectApiRoot ctpClient) {
        return (ProductSyncOptionsBuilder)new ProductSyncOptionsBuilder(ctpClient).batchSize(30);
    }

    @Nonnull
    public ProductSyncOptionsBuilder syncFilter(@Nonnull SyncFilter syncFilter) {
        this.syncFilter = syncFilter;
        return this;
    }

    @Nonnull
    public ProductSyncOptionsBuilder ensurePriceChannels(boolean ensurePriceChannels) {
        this.ensurePriceChannels = ensurePriceChannels;
        return this;
    }

    @Override
    @Nonnull
    public ProductSyncOptions build() {
        return new ProductSyncOptions(this.ctpClient, this.errorCallback, this.warningCallback, this.batchSize, this.syncFilter, this.beforeUpdateCallback, this.beforeCreateCallback, this.cacheSize, this.ensurePriceChannels);
    }

    @Override
    protected ProductSyncOptionsBuilder getThis() {
        return this;
    }
}

