/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.common.PriceDraft;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.product.Attribute;
import com.commercetools.api.models.product.AttributeBuilder;
import com.commercetools.api.models.product.CategoryOrderHints;
import com.commercetools.api.models.product.CategoryOrderHintsBuilder;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductDraftBuilder;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductVariant;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.api.models.product.ProductVariantDraftBuilder;
import com.commercetools.api.models.product_type.ProductTypeResourceIdentifier;
import com.commercetools.api.models.product_type.ProductTypeResourceIdentifierBuilder;
import com.commercetools.api.models.state.StateResourceIdentifier;
import com.commercetools.api.models.state.StateResourceIdentifierBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryReference;
import com.commercetools.api.models.tax_category.TaxCategoryResourceIdentifier;
import com.commercetools.api.models.tax_category.TaxCategoryResourceIdentifierBuilder;
import com.commercetools.sync.commons.helpers.CategoryResourceIdentifierPair;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.utils.AssetUtils;
import com.commercetools.sync.products.utils.PriceUtils;
import com.commercetools.sync.products.utils.VariantReferenceResolutionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductReferenceResolutionUtils {
    @Nonnull
    public static List<ProductDraft> mapToProductDrafts(@Nonnull List<ProductProjection> products, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return products.stream().filter(Objects::nonNull).map(product -> {
            ProductDraftBuilder productDraftBuilder = ProductReferenceResolutionUtils.getDraftBuilderFromStagedProduct(product);
            CategoryResourceIdentifierPair categoryResourceIdentifierPair = ProductReferenceResolutionUtils.mapToCategoryReferencePair(product, referenceIdToKeyCache);
            List<CategoryResourceIdentifier> categoryResourceIdentifiers = categoryResourceIdentifierPair.getCategoryResourceIdentifiers();
            CategoryOrderHints categoryOrderHintsWithKeys = categoryResourceIdentifierPair.getCategoryOrderHints();
            List allVariants = product.getAllVariants();
            List<ProductVariantDraft> variantDraftsWithKeys = VariantReferenceResolutionUtils.mapToProductVariantDrafts(allVariants, referenceIdToKeyCache);
            ProductVariantDraft masterVariantDraftWithKeys = variantDraftsWithKeys.remove(0);
            ProductTypeResourceIdentifier productTypeResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)product.getProductType(), referenceIdToKeyCache, (id, key) -> ProductTypeResourceIdentifierBuilder.of().id(id).key(key).build());
            TaxCategoryResourceIdentifier taxCategoryResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)product.getTaxCategory(), referenceIdToKeyCache, (id, key) -> TaxCategoryResourceIdentifierBuilder.of().key(key).id(id).build());
            StateResourceIdentifier stateResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)product.getState(), referenceIdToKeyCache, (id, key) -> StateResourceIdentifierBuilder.of().key(key).id(id).build());
            return productDraftBuilder.masterVariant(masterVariantDraftWithKeys).variants(variantDraftsWithKeys).productType(productTypeResourceIdentifier).categories(categoryResourceIdentifiers).categoryOrderHints(categoryOrderHintsWithKeys).taxCategory(taxCategoryResourceIdentifier).state(stateResourceIdentifier).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static ProductDraftBuilder getDraftBuilderFromStagedProduct(@Nonnull ProductProjection product) {
        List allVariants = product.getVariants().stream().map(productVariant -> ProductReferenceResolutionUtils.createProductVariantDraft(productVariant)).collect(Collectors.toList());
        ProductVariantDraft masterVariant = ProductReferenceResolutionUtils.createProductVariantDraft(product.getMasterVariant());
        return ProductDraftBuilder.of().productType(ProductTypeResourceIdentifierBuilder.of().id(product.getProductType().getId()).build()).name(product.getName()).slug(product.getSlug()).masterVariant(masterVariant).variants(allVariants).metaDescription(product.getMetaDescription()).metaKeywords(product.getMetaKeywords()).metaTitle(product.getMetaTitle()).description(product.getDescription()).searchKeywords(product.getSearchKeywords()).taxCategory(TaxCategoryResourceIdentifierBuilder.of().id((String)Optional.ofNullable(product.getTaxCategory()).map(TaxCategoryReference::getId).orElse(null)).build()).key(product.getKey()).categories(product.getCategories().stream().map(categoryReference -> CategoryResourceIdentifierBuilder.of().id(categoryReference.getId()).build()).collect(Collectors.toList())).categoryOrderHints(product.getCategoryOrderHints()).publish(product.getPublished());
    }

    public static ProductVariantDraft createProductVariantDraft(@Nonnull ProductVariant productVariant) {
        List<AssetDraft> assetDrafts = AssetUtils.createAssetDraft(productVariant.getAssets());
        List<PriceDraft> priceDrafts = PriceUtils.createPriceDraft(productVariant.getPrices());
        List<Attribute> attributes = ProductReferenceResolutionUtils.createAttributes(productVariant.getAttributes());
        return ProductVariantDraftBuilder.of().assets(assetDrafts).attributes(attributes).images(productVariant.getImages()).prices(priceDrafts).sku(productVariant.getSku()).key(productVariant.getKey()).build();
    }

    public static List<Attribute> createAttributes(List<Attribute> attributes) {
        return attributes.stream().map(attribute -> AttributeBuilder.of((Attribute)attribute).build()).collect(Collectors.toList());
    }

    @Nonnull
    static CategoryResourceIdentifierPair mapToCategoryReferencePair(@Nonnull ProductProjection product, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        List categoryReferences = product.getCategories();
        ArrayList<CategoryResourceIdentifier> categoryResourceIdentifiers = new ArrayList<CategoryResourceIdentifier>();
        CategoryOrderHints categoryOrderHints = product.getCategoryOrderHints();
        HashMap categoryOrderHintsMapWithKeys = new HashMap();
        categoryReferences.forEach(categoryReference -> {
            if (categoryReference != null) {
                String categoryId = categoryReference.getId();
                if (referenceIdToKeyCache.containsKey(categoryId)) {
                    String categoryOrderHintValue;
                    String categoryKey = referenceIdToKeyCache.get(categoryId);
                    if (categoryOrderHints != null && categoryOrderHints.values() != null && (categoryOrderHintValue = (String)categoryOrderHints.values().get(categoryId)) != null) {
                        categoryOrderHintsMapWithKeys.put(categoryKey, categoryOrderHintValue);
                    }
                    categoryResourceIdentifiers.add(CategoryResourceIdentifierBuilder.of().key(categoryKey).build());
                } else {
                    categoryResourceIdentifiers.add(CategoryResourceIdentifierBuilder.of().id(categoryReference.getId()).build());
                }
            }
        });
        CategoryOrderHints categoryOrderHintsWithKeys = categoryOrderHintsMapWithKeys.isEmpty() ? categoryOrderHints : CategoryOrderHintsBuilder.of().values(categoryOrderHintsMapWithKeys).build();
        return CategoryResourceIdentifierPair.of(categoryResourceIdentifiers, categoryOrderHintsWithKeys);
    }

    private ProductReferenceResolutionUtils() {
    }
}

