/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductRemoveVariantAction;
import com.commercetools.api.models.product.ProductSetSkuAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.products.ActionGroup;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import com.commercetools.sync.products.utils.ProductUpdateActionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductSyncUtils {
    private static final String REMOVE_VARIANT_ACTION_NAME = "removeVariant";
    private static final String SET_ATTRIBUTE_IN_ALL_VARIANTS_ACTION_NAME = "setAttributeInAllVariants";
    private static final String ADD_VARIANT_ACTION_NAME = "addVariant";
    private static final String CHANGE_MASTER_VARIANT_ACTION_NAME = "changeMasterVariant";
    public static final String TEMPORARY_MASTER_SKU_SUFFIX = "-temp";

    @Nonnull
    public static List<ProductUpdateAction> buildActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions, @Nonnull Map<String, AttributeMetaData> attributesMetaData) {
        SyncFilter syncFilter = syncOptions.getSyncFilter();
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>(OptionalUtils.filterEmptyOptionals(ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.NAME, () -> ProductUpdateActionUtils.buildChangeNameUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.DESCRIPTION, () -> ProductUpdateActionUtils.buildSetDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SLUG, () -> ProductUpdateActionUtils.buildChangeSlugUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SEARCHKEYWORDS, () -> ProductUpdateActionUtils.buildSetSearchKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METATITLE, () -> ProductUpdateActionUtils.buildSetMetaTitleUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METADESCRIPTION, () -> ProductUpdateActionUtils.buildSetMetaDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METAKEYWORDS, () -> ProductUpdateActionUtils.buildSetMetaKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.TAXCATEGORY, () -> ProductUpdateActionUtils.buildSetTaxCategoryUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.STATE, () -> ProductUpdateActionUtils.buildTransitionStateUpdateAction(oldProduct, newProduct))));
        List productCategoryUpdateActions = ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.CATEGORIES, () -> ProductSyncUtils.buildCategoryActions(oldProduct, newProduct));
        updateActions.addAll(productCategoryUpdateActions);
        updateActions.addAll(ProductUpdateActionUtils.buildVariantsUpdateActions(oldProduct, newProduct, syncOptions, attributesMetaData));
        boolean hasNewUpdateActions = updateActions.size() > 0;
        ProductUpdateActionUtils.buildPublishOrUnpublishUpdateAction(oldProduct, newProduct, hasNewUpdateActions).ifPresent(updateActions::add);
        return ProductSyncUtils.prioritizeUpdateActions(updateActions, oldProduct.getMasterVariant().getId(), oldProduct.getMasterVariant().getSku());
    }

    private static List<ProductUpdateAction> prioritizeUpdateActions(List<ProductUpdateAction> updateActions, Long oldMasterVariantId, String oldMasterVariantSku) {
        ProductRemoveVariantAction removeMasterVariantUpdateAction = ProductRemoveVariantAction.builder().id(oldMasterVariantId).build();
        List<ProductUpdateAction> removeVariantUpdateActionsNoMaster = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(REMOVE_VARIANT_ACTION_NAME) && !action.equals(removeMasterVariantUpdateAction));
        List<ProductUpdateAction> sameForAllUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(SET_ATTRIBUTE_IN_ALL_VARIANTS_ACTION_NAME));
        List<ProductUpdateAction> addVariantUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(ADD_VARIANT_ACTION_NAME));
        List<ProductUpdateAction> changeMasterUpdateActions = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(CHANGE_MASTER_VARIANT_ACTION_NAME));
        List<ProductUpdateAction> removeOldMasterVariantUpdateAction = ProductSyncUtils.getActionsByActionName(updateActions, action -> action.getAction().equals(REMOVE_VARIANT_ACTION_NAME) && action.equals(removeMasterVariantUpdateAction));
        List<ProductUpdateAction> temporarySetSkuUpdateAction = ProductSyncUtils.getActionsByActionName(updateActions, action -> action instanceof ProductSetSkuAction && ((ProductSetSkuAction)action).getSku().equals(oldMasterVariantSku + TEMPORARY_MASTER_SKU_SUFFIX));
        ArrayList<ProductUpdateAction> updateActionList = new ArrayList<ProductUpdateAction>(removeVariantUpdateActionsNoMaster);
        updateActionList.addAll(sameForAllUpdateActions);
        updateActionList.addAll(temporarySetSkuUpdateAction);
        updateActionList.addAll(addVariantUpdateActions);
        updateActionList.addAll(changeMasterUpdateActions);
        updateActionList.addAll(removeOldMasterVariantUpdateAction);
        updateActionList.addAll(updateActions);
        return updateActionList;
    }

    private static List<ProductUpdateAction> getActionsByActionName(List<ProductUpdateAction> updateActions, Predicate<ProductUpdateAction> updateActionPredicate) {
        List<ProductUpdateAction> filteredUpdateActions = CollectionUtils.emptyIfNull(updateActions).stream().filter(updateActionPredicate).collect(Collectors.toList());
        updateActions.removeAll(filteredUpdateActions);
        return filteredUpdateActions;
    }

    @Nonnull
    public static List<ProductUpdateAction> buildCategoryActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>();
        updateActions.addAll(ProductUpdateActionUtils.buildAddToCategoryUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildSetCategoryOrderHintUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildRemoveFromCategoryUpdateActions(oldProduct, newProduct));
        return updateActions;
    }

    private ProductSyncUtils() {
    }
}

