/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.common.LocalizedString;
import com.commercetools.api.models.product.CategoryOrderHints;
import com.commercetools.api.models.product.ProductAddToCategoryAction;
import com.commercetools.api.models.product.ProductAddVariantAction;
import com.commercetools.api.models.product.ProductAddVariantActionBuilder;
import com.commercetools.api.models.product.ProductChangeMasterVariantAction;
import com.commercetools.api.models.product.ProductChangeNameAction;
import com.commercetools.api.models.product.ProductChangeSlugAction;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductPublishAction;
import com.commercetools.api.models.product.ProductRemoveFromCategoryActionBuilder;
import com.commercetools.api.models.product.ProductRemoveVariantAction;
import com.commercetools.api.models.product.ProductSetAttributeInAllVariantsAction;
import com.commercetools.api.models.product.ProductSetAttributeInAllVariantsActionBuilder;
import com.commercetools.api.models.product.ProductSetCategoryOrderHintAction;
import com.commercetools.api.models.product.ProductSetDescriptionAction;
import com.commercetools.api.models.product.ProductSetMetaDescriptionAction;
import com.commercetools.api.models.product.ProductSetMetaKeywordsAction;
import com.commercetools.api.models.product.ProductSetMetaTitleAction;
import com.commercetools.api.models.product.ProductSetSearchKeywordsActionBuilder;
import com.commercetools.api.models.product.ProductSetSkuActionBuilder;
import com.commercetools.api.models.product.ProductSetTaxCategoryAction;
import com.commercetools.api.models.product.ProductTransitionStateAction;
import com.commercetools.api.models.product.ProductUnpublishAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.api.models.product.ProductVariant;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.api.models.product.SearchKeywords;
import com.commercetools.api.models.state.StateResourceIdentifier;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.products.ActionGroup;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import com.commercetools.sync.products.utils.FilterUtils;
import com.commercetools.sync.products.utils.ProductVariantUpdateActionUtils;
import com.commercetools.sync.products.utils.UnorderedCollectionSyncUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public final class ProductUpdateActionUtils {
    private static final String BLANK_VARIANT_KEY = "The variant key is blank.";
    static final String NULL_VARIANT = "The variant is null.";
    static final String BLANK_OLD_MASTER_VARIANT_KEY = "Old master variant key is blank.";
    static final String BLANK_NEW_MASTER_VARIANT_KEY = "New master variant null or has blank key.";
    static final String BLANK_NEW_MASTER_VARIANT_SKU = "New master variant has blank SKU.";

    @Nonnull
    public static Optional<ProductUpdateAction> buildChangeNameUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newName = newProduct.getName();
        LocalizedString oldName = oldProduct.getName();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldName, newName, () -> ProductChangeNameAction.builder().name(newName).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetDescriptionUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newDescription = newProduct.getDescription();
        LocalizedString oldDescription = oldProduct.getDescription();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldDescription, newDescription, () -> ProductSetDescriptionAction.builder().description(newDescription).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildChangeSlugUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newSlug = newProduct.getSlug();
        LocalizedString oldSlug = oldProduct.getSlug();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldSlug, newSlug, () -> ProductChangeSlugAction.builder().slug(newSlug).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static List<ProductUpdateAction> buildAddToCategoryUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        List newCategories = newProduct.getCategories();
        List oldCategories = oldProduct.getCategories();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategories, newCategories, () -> {
            ArrayList updateActions = new ArrayList();
            List<CategoryResourceIdentifier> newCategoriesResourceIdentifiers = CollectionUtils.filterCollection(newCategories, newCategoryReference -> oldCategories.stream().noneMatch(oldResourceReference -> CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(oldResourceReference, newCategoryReference))).collect(Collectors.toList());
            newCategoriesResourceIdentifiers.forEach(categoryResourceIdentifier -> updateActions.add(ProductAddToCategoryAction.builder().category(categoryResourceIdentifier).staged(Boolean.valueOf(true)).build()));
            return updateActions;
        });
    }

    @Nonnull
    public static List<ProductUpdateAction> buildSetCategoryOrderHintUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        CategoryOrderHints newCategoryOrderHints = newProduct.getCategoryOrderHints();
        CategoryOrderHints oldCategoryOrderHints = oldProduct.getCategoryOrderHints();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategoryOrderHints, newCategoryOrderHints, () -> {
            Set newCategoryIds = newProduct.getCategories() == null ? Collections.emptySet() : newProduct.getCategories().stream().map(CategoryResourceIdentifier::getId).collect(Collectors.toSet());
            ArrayList updateActions = new ArrayList();
            Map newMap = Objects.nonNull(newCategoryOrderHints) && Objects.nonNull(newCategoryOrderHints.values()) ? newCategoryOrderHints.values() : Collections.emptyMap();
            Map oldMap = Objects.nonNull(oldCategoryOrderHints) && Objects.nonNull(oldCategoryOrderHints.values()) ? oldCategoryOrderHints.values() : Collections.emptyMap();
            oldMap.forEach((categoryId, value) -> {
                if (!newMap.containsKey(categoryId) && newCategoryIds.contains(categoryId)) {
                    updateActions.add(ProductSetCategoryOrderHintAction.builder().categoryId(categoryId).orderHint(null).staged(Boolean.valueOf(true)).build());
                }
            });
            newMap.forEach((categoryId, value) -> {
                if (!oldMap.containsKey(categoryId) || !Objects.equals(oldMap.get(categoryId), value)) {
                    updateActions.add(ProductSetCategoryOrderHintAction.builder().orderHint(value).categoryId(categoryId).staged(Boolean.valueOf(true)).build());
                }
            });
            return updateActions;
        });
    }

    @Nonnull
    public static List<ProductUpdateAction> buildRemoveFromCategoryUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        List newCategories = newProduct.getCategories();
        List oldCategories = oldProduct.getCategories();
        return CommonTypeUpdateActionUtils.buildUpdateActions(oldCategories, newCategories, () -> {
            ArrayList updateActions = new ArrayList();
            CollectionUtils.filterCollection(oldCategories, oldCategoryReference -> newCategories.stream().noneMatch(newResourceIdentifier -> CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(oldCategoryReference, newResourceIdentifier))).forEach(categoryReference -> updateActions.add(ProductRemoveFromCategoryActionBuilder.of().category(CategoryResourceIdentifierBuilder.of().id(categoryReference.getId()).build()).staged(Boolean.valueOf(true)).build()));
            return updateActions;
        });
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetSearchKeywordsUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        SearchKeywords newSearchKeywords = newProduct.getSearchKeywords();
        SearchKeywords oldSearchKeywords = oldProduct.getSearchKeywords();
        if (newSearchKeywords == null) {
            return Optional.empty();
        }
        Map newSearchValues = newSearchKeywords.values();
        Map oldSearchValue = oldSearchKeywords.values();
        if (newSearchValues == null && (oldSearchValue == null || oldSearchValue.size() == 0)) {
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldSearchKeywords, newSearchKeywords, () -> ProductSetSearchKeywordsActionBuilder.of().searchKeywords(newSearchKeywords).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetMetaDescriptionUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaDescription = newProduct.getMetaDescription();
        LocalizedString oldMetaDescription = oldProduct.getMetaDescription();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaDescription, newMetaDescription, () -> ProductSetMetaDescriptionAction.builder().metaDescription(newMetaDescription).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetMetaKeywordsUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaKeywords = newProduct.getMetaKeywords();
        LocalizedString oldMetaKeywords = oldProduct.getMetaKeywords();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaKeywords, newMetaKeywords, () -> ProductSetMetaKeywordsAction.builder().metaKeywords(newMetaKeywords).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetMetaTitleUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        LocalizedString newMetaTitle = newProduct.getMetaTitle();
        LocalizedString oldMetaTitle = oldProduct.getMetaTitle();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldMetaTitle, newMetaTitle, () -> ProductSetMetaTitleAction.builder().metaTitle(newMetaTitle).build());
    }

    @Nonnull
    public static List<ProductUpdateAction> buildVariantsUpdateActions(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions, @Nonnull Map<String, AttributeMetaData> attributesMetaData) {
        if (ProductUpdateActionUtils.haveInvalidMasterVariants(oldProduct, newProduct, syncOptions)) {
            return Collections.emptyList();
        }
        ProductVariant oldMasterVariant = oldProduct.getMasterVariant();
        List oldProductVariantsWithoutMaster = oldProduct.getVariants();
        Map<String, ProductVariant> oldProductVariantsNoMaster = CollectionUtils.collectionToMap(oldProductVariantsWithoutMaster, ProductVariant::getKey);
        HashMap<String, ProductVariant> oldProductVariantsWithMaster = new HashMap<String, ProductVariant>(oldProductVariantsNoMaster);
        oldProductVariantsWithMaster.put(oldMasterVariant.getKey(), oldMasterVariant);
        ArrayList<ProductVariantDraft> newAllProductVariants = new ArrayList<ProductVariantDraft>(newProduct.getVariants() == null ? Collections.emptyList() : newProduct.getVariants());
        ProductVariantDraft newMasterVariant = newProduct.getMasterVariant();
        newAllProductVariants.add(newMasterVariant);
        List<ProductUpdateAction> updateActions = UnorderedCollectionSyncUtils.buildRemoveUpdateActions(oldProductVariantsWithoutMaster, newAllProductVariants, ProductVariant::getKey, ProductVariantDraft::getKey, variant -> ProductRemoveVariantAction.builder().id(variant.getId()).staged(Boolean.valueOf(true)).build());
        CollectionUtils.emptyIfNull(newAllProductVariants).forEach(newProductVariant -> {
            if (newProductVariant == null) {
                ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, NULL_VARIANT, syncOptions);
            } else {
                String newProductVariantKey = newProductVariant.getKey();
                if (StringUtils.isBlank((CharSequence)newProductVariantKey)) {
                    ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_VARIANT_KEY, syncOptions);
                } else {
                    ProductVariant matchingOldVariant = (ProductVariant)oldProductVariantsWithMaster.get(newProductVariantKey);
                    List updateOrAddVariant = Optional.ofNullable(matchingOldVariant).map(oldVariant -> ProductUpdateActionUtils.collectAllVariantUpdateActions(ProductUpdateActionUtils.getSameForAllUpdateActions(updateActions), oldProduct, newProduct, oldVariant, newProductVariant, attributesMetaData, syncOptions)).orElseGet(() -> Collections.singletonList(ProductUpdateActionUtils.buildAddVariantUpdateActionFromDraft(newProductVariant)));
                    updateActions.addAll(updateOrAddVariant);
                }
            }
        });
        updateActions.addAll(ProductUpdateActionUtils.buildChangeMasterVariantUpdateAction(oldProduct, newProduct, syncOptions));
        if (newMasterVariant != null && ProductUpdateActionUtils.hasAddVariantUpdateAction(updateActions) && ProductUpdateActionUtils.hasChangeMasterVariantUpdateAction(updateActions)) {
            String oldMasterVariantSku = oldMasterVariant.getSku();
            boolean hasConflictingAddVariant = ProductUpdateActionUtils.hasConflictingAddVariantUpdateAction(updateActions, oldMasterVariantSku);
            if (hasConflictingAddVariant) {
                updateActions.add((ProductUpdateAction)ProductSetSkuActionBuilder.of().variantId(oldMasterVariant.getId()).sku(oldMasterVariant.getSku() + "-temp").build());
            }
            updateActions.addAll(ProductUpdateActionUtils.buildSetAttributeInAllVariantsUpdateAction(attributesMetaData, oldProduct.getMasterVariant(), newMasterVariant));
        }
        return updateActions;
    }

    private static boolean hasConflictingAddVariantUpdateAction(List<ProductUpdateAction> updateActions, String oldMasterVariantSku) {
        return updateActions.stream().anyMatch(productUpdateAction -> productUpdateAction instanceof ProductAddVariantAction && ((ProductAddVariantAction)productUpdateAction).getSku() != null && ((ProductAddVariantAction)productUpdateAction).getSku().equals(oldMasterVariantSku));
    }

    private static List<ProductUpdateAction> getSameForAllUpdateActions(List<ProductUpdateAction> updateActions) {
        return CollectionUtils.emptyIfNull(updateActions).stream().filter(productUpdateAction -> productUpdateAction instanceof ProductSetAttributeInAllVariantsAction).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ProductVariantDraft> getAllVariants(@Nonnull ProductDraft productDraft) {
        ArrayList<ProductVariantDraft> allVariants = new ArrayList<ProductVariantDraft>();
        if (productDraft.getMasterVariant() != null) {
            allVariants.add(productDraft.getMasterVariant());
            if (productDraft.getVariants() != null && productDraft.getVariants().size() > 0) {
                allVariants.addAll(productDraft.getVariants());
            }
        }
        return allVariants;
    }

    private static boolean hasDuplicateSameForAllAction(List<ProductUpdateAction> sameForAllUpdateActions, ProductUpdateAction collectedUpdateAction) {
        return !(collectedUpdateAction instanceof ProductSetAttributeInAllVariantsAction) || ProductUpdateActionUtils.isSameForAllActionNew(sameForAllUpdateActions, collectedUpdateAction);
    }

    private static boolean isSameForAllActionNew(List<ProductUpdateAction> sameForAllUpdateActions, ProductUpdateAction productUpdateAction) {
        return sameForAllUpdateActions.stream().noneMatch(previouslyAddedAction -> previouslyAddedAction instanceof ProductSetAttributeInAllVariantsAction && previouslyAddedAction.getAction().equals(productUpdateAction.getAction()));
    }

    @Nonnull
    private static List<ProductUpdateAction> collectAllVariantUpdateActions(@Nonnull List<ProductUpdateAction> sameForAllUpdateActions, @Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductVariant oldProductVariant, @Nonnull ProductVariantDraft newProductVariant, @Nonnull Map<String, AttributeMetaData> attributesMetaData, @Nonnull ProductSyncOptions syncOptions) {
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>();
        SyncFilter syncFilter = syncOptions.getSyncFilter();
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.ATTRIBUTES, () -> CollectionUtils.emptyIfNull(ProductVariantUpdateActionUtils.buildProductVariantAttributesUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, attributesMetaData, syncOptions)).stream().filter(collectedUpdateAction -> ProductUpdateActionUtils.hasDuplicateSameForAllAction(sameForAllUpdateActions, collectedUpdateAction)).collect(Collectors.toList())));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.IMAGES, () -> ProductVariantUpdateActionUtils.buildProductVariantImagesUpdateActions(oldProductVariant, newProductVariant)));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.PRICES, () -> ProductVariantUpdateActionUtils.buildProductVariantPricesUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, syncOptions)));
        updateActions.addAll(ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.ASSETS, () -> ProductVariantUpdateActionUtils.buildProductVariantAssetsUpdateActions(oldProduct, newProduct, oldProductVariant, newProductVariant, syncOptions)));
        ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SKU, () -> ProductVariantUpdateActionUtils.buildProductVariantSkuUpdateAction(oldProductVariant, newProductVariant)).ifPresent(updateActions::add);
        return updateActions;
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildPublishOrUnpublishUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, boolean hasNewUpdateActions) {
        boolean isNewProductPublished = BooleanUtils.toBoolean((Boolean)newProduct.getPublish());
        boolean isOldProductPublished = BooleanUtils.toBoolean((Boolean)oldProduct.getPublished());
        if (isNewProductPublished) {
            if (isOldProductPublished && (hasNewUpdateActions || oldProduct.getHasStagedChanges().booleanValue())) {
                return Optional.of(ProductPublishAction.of());
            }
            return CommonTypeUpdateActionUtils.buildUpdateAction(isOldProductPublished, true, ProductPublishAction::of);
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(isOldProductPublished, false, ProductUnpublishAction::of);
    }

    @Nonnull
    public static List<ProductUpdateAction> buildChangeMasterVariantUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions) {
        String newKey = newProduct.getMasterVariant().getKey();
        String oldKey = oldProduct.getMasterVariant().getKey();
        if (ProductUpdateActionUtils.haveInvalidMasterVariants(oldProduct, newProduct, syncOptions)) {
            return Collections.emptyList();
        }
        return CommonTypeUpdateActionUtils.buildUpdateActions(newKey, oldKey, () -> {
            String newSku = newProduct.getMasterVariant().getSku();
            if (StringUtils.isBlank((CharSequence)newSku)) {
                ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_NEW_MASTER_VARIANT_SKU, syncOptions);
                return Collections.emptyList();
            }
            ArrayList<Object> updateActions = new ArrayList<Object>(2);
            updateActions.add(ProductChangeMasterVariantAction.builder().sku(newSku).staged(Boolean.valueOf(true)).build());
            if (newProduct.getVariants() == null || newProduct.getVariants().stream().allMatch(Objects::isNull) || newProduct.getVariants().stream().noneMatch(variant -> Objects.equals(variant.getKey(), oldKey))) {
                updateActions.add(ProductRemoveVariantAction.builder().id(oldProduct.getMasterVariant().getId()).build());
            }
            return updateActions;
        });
    }

    private static List<ProductUpdateAction> buildSetAttributeInAllVariantsUpdateAction(@Nonnull Map<String, AttributeMetaData> attributesMetaData, @Nonnull ProductVariant oldMasterVariant, @Nonnull ProductVariantDraft newMasterVariant) {
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>();
        List attributes = newMasterVariant.getAttributes();
        if (attributes != null) {
            attributes.forEach(attributeDraft -> {
                AttributeMetaData attributeMetaData = (AttributeMetaData)attributesMetaData.get(attributeDraft.getName());
                Boolean isAttributesEqual = oldMasterVariant.getAttributes().stream().filter(oldAttribute -> oldAttribute.getName().equals(attributeDraft.getName())).findAny().map(attribute -> attribute.getValue().equals(attributeDraft.getValue())).orElse(false);
                if (attributeMetaData.isSameForAll() && !isAttributesEqual.booleanValue()) {
                    updateActions.add(0, (ProductUpdateAction)ProductSetAttributeInAllVariantsActionBuilder.of().name(attributeDraft.getName()).value(attributeDraft.getValue()).build());
                }
            });
        }
        return updateActions;
    }

    private static boolean hasChangeMasterVariantUpdateAction(List<ProductUpdateAction> updateActions) {
        return updateActions.stream().anyMatch(updateAction -> updateAction instanceof ProductChangeMasterVariantAction);
    }

    private static boolean hasAddVariantUpdateAction(List<ProductUpdateAction> updateActions) {
        return updateActions.stream().anyMatch(updateAction -> updateAction instanceof ProductAddVariantAction);
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetTaxCategoryUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldProduct.getTaxCategory(), newProduct.getTaxCategory(), () -> ProductSetTaxCategoryAction.builder().taxCategory(newProduct.getTaxCategory()).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildTransitionStateUpdateAction(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct) {
        return Optional.ofNullable(newProduct.getState() != null && !Objects.equals(Optional.ofNullable(oldProduct.getState()).map(stateReference -> StateResourceIdentifier.builder().id(stateReference.getId()).build()).orElse(null), newProduct.getState()) ? ProductTransitionStateAction.builder().state(newProduct.getState()).build() : null);
    }

    @Nonnull
    static ProductUpdateAction buildAddVariantUpdateActionFromDraft(@Nonnull ProductVariantDraft draft) {
        return ProductAddVariantActionBuilder.of().prices(draft.getPrices()).sku(draft.getSku()).attributes(draft.getAttributes()).staged(Boolean.valueOf(true)).key(draft.getKey()).images(draft.getImages()).assets(draft.getAssets()).build();
    }

    @Nonnull
    static <T> Optional<T> buildActionIfPassesFilter(@Nonnull SyncFilter syncFilter, @Nonnull ActionGroup actionGroup, @Nonnull Supplier<Optional<T>> updateActionSupplier) {
        return FilterUtils.executeSupplierIfPassesFilter(syncFilter, actionGroup, updateActionSupplier, Optional::empty);
    }

    @Nonnull
    static <T> List<T> buildActionsIfPassesFilter(@Nonnull SyncFilter syncFilter, @Nonnull ActionGroup actionGroup, @Nonnull Supplier<List<T>> updateActionSupplier) {
        return FilterUtils.executeSupplierIfPassesFilter(syncFilter, actionGroup, updateActionSupplier, Collections::emptyList);
    }

    private static boolean haveInvalidMasterVariants(@Nonnull ProductProjection oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions) {
        ProductVariantDraft newMasterVariant;
        boolean hasError = false;
        ProductVariant oldMasterVariant = oldProduct.getMasterVariant();
        if (StringUtils.isBlank((CharSequence)oldMasterVariant.getKey())) {
            ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_OLD_MASTER_VARIANT_KEY, syncOptions);
            hasError = true;
        }
        if ((newMasterVariant = newProduct.getMasterVariant()) == null || StringUtils.isBlank((CharSequence)newMasterVariant.getKey())) {
            ProductUpdateActionUtils.handleBuildVariantsUpdateActionsError(oldProduct, BLANK_NEW_MASTER_VARIANT_KEY, syncOptions);
            hasError = true;
        }
        return hasError;
    }

    private static void handleBuildVariantsUpdateActionsError(@Nonnull ProductProjection oldProduct, @Nonnull String reason, @Nonnull ProductSyncOptions syncOptions) {
        syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build variants update actions on the product with key '%s'. Reason: %s", oldProduct.getKey(), reason)), oldProduct, null, null);
    }

    private ProductUpdateActionUtils() {
    }
}

