/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.product_type.AttributeDefinitionDraft;
import com.commercetools.api.models.product_type.AttributeDefinitionDraftBuilder;
import com.commercetools.api.models.product_type.AttributeNestedType;
import com.commercetools.api.models.product_type.AttributeNestedTypeBuilder;
import com.commercetools.api.models.product_type.AttributeSetType;
import com.commercetools.api.models.product_type.AttributeSetTypeBuilder;
import com.commercetools.api.models.product_type.AttributeType;
import com.commercetools.api.models.product_type.ProductTypeReference;
import com.commercetools.api.models.product_type.ProductTypeReferenceBuilder;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.services.ProductTypeService;
import io.vrap.rmf.base.client.utils.CompletableFutureUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class AttributeDefinitionReferenceResolver
extends BaseReferenceResolver<AttributeDefinitionDraft, ProductTypeSyncOptions> {
    private final ProductTypeService productTypeService;

    public AttributeDefinitionReferenceResolver(@Nonnull ProductTypeSyncOptions options, @Nonnull ProductTypeService productTypeService) {
        super(options);
        this.productTypeService = productTypeService;
    }

    @Override
    @Nonnull
    public CompletionStage<AttributeDefinitionDraft> resolveReferences(@Nonnull AttributeDefinitionDraft attributeDefinitionDraft) {
        AttributeDefinitionDraftBuilder draftBuilder = AttributeDefinitionDraftBuilder.of((AttributeDefinitionDraft)attributeDefinitionDraft);
        return this.resolveNestedAttributeTypeReferences(draftBuilder).handle(ImmutablePair::new).thenCompose(result -> {
            Throwable exception = (Throwable)result.getValue();
            AttributeDefinitionDraftBuilder resolvedBuilder = (AttributeDefinitionDraftBuilder)result.getKey();
            if (exception == null) {
                return CompletableFuture.completedFuture(resolvedBuilder.build());
            }
            String errorMessage = String.format("Failed to resolve references on attribute definition with name '%s'.", attributeDefinitionDraft.getName());
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage, exception.getCause()));
        });
    }

    @Nonnull
    private CompletionStage<AttributeDefinitionDraftBuilder> resolveNestedAttributeTypeReferences(@Nonnull AttributeDefinitionDraftBuilder attributeDefinitionDraftBuilder) {
        AttributeType attributeType = attributeDefinitionDraftBuilder.getType();
        if (attributeType instanceof AttributeNestedType) {
            return this.resolveNestedTypeReference((AttributeNestedType)attributeType).thenApply(arg_0 -> ((AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder).type(arg_0));
        }
        if (attributeType instanceof AttributeSetType) {
            AttributeSetType setAttributeType = (AttributeSetType)attributeType;
            AttributeType elementType = setAttributeType.getElementType();
            AtomicInteger maxDepth = new AtomicInteger();
            AttributeType nestedAttributeType = elementType;
            if (elementType instanceof AttributeSetType) {
                maxDepth.incrementAndGet();
                nestedAttributeType = this.getNestedAttributeType((AttributeSetType)elementType, maxDepth);
            }
            if (nestedAttributeType instanceof AttributeNestedType) {
                return this.resolveNestedAttributeTypeReferences(attributeDefinitionDraftBuilder, maxDepth, (AttributeNestedType)nestedAttributeType);
            }
        }
        return CompletableFuture.completedFuture(attributeDefinitionDraftBuilder);
    }

    @Nonnull
    private CompletionStage<AttributeDefinitionDraftBuilder> resolveNestedAttributeTypeReferences(@Nonnull AttributeDefinitionDraftBuilder attributeDefinitionDraftBuilder, @Nonnull AtomicInteger maxDepth, @Nonnull AttributeNestedType nestedAttributeType) {
        return this.resolveNestedTypeReference(nestedAttributeType).thenApply(resolvedNestedAttributeType -> {
            AttributeSetType setAttributeTypeChain = AttributeSetTypeBuilder.of().elementType((AttributeType)resolvedNestedAttributeType).build();
            for (int i = 0; i < maxDepth.get(); ++i) {
                setAttributeTypeChain = AttributeSetTypeBuilder.of().elementType((AttributeType)setAttributeTypeChain).build();
            }
            return setAttributeTypeChain;
        }).thenApply(arg_0 -> ((AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder).type(arg_0));
    }

    @Nullable
    private AttributeType getNestedAttributeType(@Nonnull AttributeSetType setAttributeType, @Nonnull AtomicInteger maxDepth) {
        AttributeType elementType = setAttributeType.getElementType();
        if (elementType instanceof AttributeSetType) {
            maxDepth.incrementAndGet();
            return this.getNestedAttributeType((AttributeSetType)elementType, maxDepth);
        }
        return elementType;
    }

    @Nonnull
    private CompletionStage<AttributeNestedType> resolveNestedTypeReference(@Nonnull AttributeNestedType nestedAttributeType) {
        ProductTypeReference typeReference = nestedAttributeType.getTypeReference();
        return this.resolveProductTypeReference(typeReference).thenApply(optionalResolvedReference -> optionalResolvedReference.map(resolvedReference -> AttributeNestedTypeBuilder.of().typeReference(resolvedReference).build()).orElse(nestedAttributeType));
    }

    @Nonnull
    private CompletionStage<Optional<ProductTypeReference>> resolveProductTypeReference(@Nonnull ProductTypeReference typeReference) {
        String resourceKey;
        try {
            resourceKey = AttributeDefinitionReferenceResolver.getIdFromReference((Reference)typeReference);
        }
        catch (ReferenceResolutionException exception) {
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException("Failed to resolve NestedType productType reference.", exception));
        }
        return this.productTypeService.fetchCachedProductTypeId(resourceKey).thenApply(optionalId -> optionalId.map(id -> ProductTypeReferenceBuilder.of().id(id).build()));
    }
}

