/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.models.product_type.AttributeDefinition;
import com.commercetools.api.models.product_type.ProductType;
import com.commercetools.api.models.product_type.ProductTypeChangeDescriptionActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeNameActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeDraft;
import com.commercetools.api.models.product_type.ProductTypeUpdateAction;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.utils.AttributeDefinitionsUpdateActionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ProductTypeUpdateActionUtils {
    @Nonnull
    public static Optional<ProductTypeUpdateAction> buildChangeNameAction(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductType.getName(), newProductType.getName(), () -> ProductTypeChangeNameActionBuilder.of().name(newProductType.getName()).build());
    }

    @Nonnull
    public static Optional<ProductTypeUpdateAction> buildChangeDescriptionAction(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldProductType.getDescription(), newProductType.getDescription(), () -> ProductTypeChangeDescriptionActionBuilder.of().description(newProductType.getDescription()).build());
    }

    @Nonnull
    public static List<ProductTypeUpdateAction> buildAttributesUpdateActions(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType, @Nonnull ProductTypeSyncOptions syncOptions) {
        try {
            List<AttributeDefinition> attributes = oldProductType.getAttributes();
            if (attributes == null) {
                attributes = Collections.emptyList();
            }
            return AttributeDefinitionsUpdateActionUtils.buildAttributeDefinitionsUpdateActions(attributes, newProductType.getAttributes());
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the attributes definitions of the product type with the key '%s'. Reason: %s", oldProductType.getKey(), exception), exception), oldProductType, newProductType, null);
            return Collections.emptyList();
        }
    }

    private ProductTypeUpdateActionUtils() {
    }
}

