/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyProductTypesGet;
import com.commercetools.api.client.ByProjectKeyProductTypesKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyProductTypesPost;
import com.commercetools.api.client.QueryUtils;
import com.commercetools.api.client.SimplePagedQueryResourceRequest;
import com.commercetools.api.models.product_type.ProductType;
import com.commercetools.api.models.product_type.ProductTypeDraft;
import com.commercetools.api.models.product_type.ProductTypePagedQueryResponse;
import com.commercetools.api.models.product_type.ProductTypeUpdateAction;
import com.commercetools.api.models.product_type.ProductTypeUpdateBuilder;
import com.commercetools.api.predicates.query.product_type.ProductTypeQueryBuilderDsl;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.impl.BaseService;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductTypeServiceImpl
extends BaseService<BaseSyncOptions, ProductType, ProductTypeDraft, ByProjectKeyProductTypesGet, ProductTypePagedQueryResponse, ByProjectKeyProductTypesKeyByKeyGet, ProductType, ProductTypeQueryBuilderDsl, ByProjectKeyProductTypesPost>
implements ProductTypeService {
    private final Map<String, Map<String, AttributeMetaData>> productsAttributesMetaData = new ConcurrentHashMap<String, Map<String, AttributeMetaData>>();

    public ProductTypeServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> categoryKeys) {
        return super.cacheKeysToIdsUsingGraphQl(categoryKeys, GraphQlQueryResource.PRODUCT_TYPES);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedProductTypeId(@Nonnull String key) {
        ByProjectKeyProductTypesGet query = this.syncOptions.getCtpClient().productTypes().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return this.fetchCachedResourceId(key, query);
    }

    @Nonnull
    private static Map<String, AttributeMetaData> getAttributeMetaDataMap(@Nonnull ProductType productType) {
        return productType.getAttributes().stream().map(AttributeMetaData::of).collect(Collectors.toMap(AttributeMetaData::getName, attributeMetaData -> attributeMetaData));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Map<String, AttributeMetaData>>> fetchCachedProductAttributeMetaDataMap(@Nonnull String productTypeId) {
        if (this.productsAttributesMetaData.isEmpty()) {
            return this.fetchAndCacheProductMetaData(productTypeId);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.productsAttributesMetaData.get(productTypeId)));
    }

    @Nonnull
    private CompletionStage<Optional<Map<String, AttributeMetaData>>> fetchAndCacheProductMetaData(@Nonnull String productTypeId) {
        Consumer<List> productTypePageConsumer = productTypePage -> productTypePage.forEach(type -> {
            String id = type.getId();
            this.productsAttributesMetaData.put(id, ProductTypeServiceImpl.getAttributeMetaDataMap(type));
        });
        ByProjectKeyProductTypesGet byProjectKeyProductTypesGet = this.syncOptions.getCtpClient().productTypes().get();
        return QueryUtils.queryAll((SimplePagedQueryResourceRequest)byProjectKeyProductTypesGet, productTypePageConsumer).thenApply(result -> Optional.ofNullable(this.productsAttributesMetaData.get(productTypeId)));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ProductType>> fetchMatchingProductTypesByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, ProductType::getKey, keysNotCached -> this.syncOptions.getCtpClient().productTypes().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductType>> createProductType(@Nonnull ProductTypeDraft productTypeDraft) {
        return super.createResource(productTypeDraft, ProductTypeDraft::getKey, ProductType::getId, Function.identity(), () -> this.syncOptions.getCtpClient().productTypes().post(productTypeDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<ProductType> updateProductType(@Nonnull ProductType productType, @Nonnull List<ProductTypeUpdateAction> updateActions) {
        List<List<ProductTypeUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)productType));
        for (List<ProductTypeUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedProductType -> this.syncOptions.getCtpClient().productTypes().withId(updatedProductType.getId()).post(ProductTypeUpdateBuilder.of().actions(batch).version(updatedProductType.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductType>> fetchProductType(@Nullable String key) {
        return super.fetchResource(key, this.syncOptions.getCtpClient().productTypes().withKey(key).get());
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull ByProjectKeyProductTypesGet query) {
        return super.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }
}

