/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyTaxCategoriesGet;
import com.commercetools.api.client.ByProjectKeyTaxCategoriesKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyTaxCategoriesPost;
import com.commercetools.api.models.tax_category.TaxCategory;
import com.commercetools.api.models.tax_category.TaxCategoryDraft;
import com.commercetools.api.models.tax_category.TaxCategoryPagedQueryResponse;
import com.commercetools.api.models.tax_category.TaxCategoryUpdateAction;
import com.commercetools.api.models.tax_category.TaxCategoryUpdateBuilder;
import com.commercetools.api.predicates.query.tax_category.TaxCategoryQueryBuilderDsl;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import com.commercetools.sync.taxcategories.TaxCategorySyncOptions;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TaxCategoryServiceImpl
extends BaseServiceWithKey<TaxCategorySyncOptions, TaxCategory, TaxCategoryDraft, ByProjectKeyTaxCategoriesGet, TaxCategoryPagedQueryResponse, ByProjectKeyTaxCategoriesKeyByKeyGet, TaxCategory, TaxCategoryQueryBuilderDsl, ByProjectKeyTaxCategoriesPost>
implements TaxCategoryService {
    public TaxCategoryServiceImpl(@Nonnull TaxCategorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> taxCategoryKeys) {
        return super.cacheKeysToIdsUsingGraphQl(taxCategoryKeys, GraphQlQueryResource.TAX_CATEGORIES);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTaxCategoryId(@Nullable String key) {
        if (key == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        ByProjectKeyTaxCategoriesGet query = ((TaxCategorySyncOptions)this.syncOptions).getCtpClient().taxCategories().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return super.fetchCachedResourceId(key, query);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<TaxCategory>> fetchMatchingTaxCategoriesByKeys(@Nonnull Set<String> keys) {
        return super.fetchMatchingResources(keys, TaxCategory::getKey, keysNotCached -> ((TaxCategorySyncOptions)this.syncOptions).getCtpClient().taxCategories().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<TaxCategory>> fetchTaxCategory(@Nullable String key) {
        return super.fetchResource(key, ((TaxCategorySyncOptions)this.syncOptions).getCtpClient().taxCategories().withKey(key).get());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<TaxCategory>> createTaxCategory(@Nonnull TaxCategoryDraft taxCategoryDraft) {
        return super.createResource(taxCategoryDraft, TaxCategoryDraft::getKey, TaxCategory::getId, Function.identity(), () -> ((TaxCategorySyncOptions)this.syncOptions).getCtpClient().taxCategories().post(taxCategoryDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<TaxCategory> updateTaxCategory(@Nonnull TaxCategory taxCategory, @Nonnull List<TaxCategoryUpdateAction> updateActions) {
        List<List<TaxCategoryUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)taxCategory));
        for (List<TaxCategoryUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedTaxCategory -> ((TaxCategorySyncOptions)this.syncOptions).getCtpClient().taxCategories().withId(updatedTaxCategory.getId()).post(TaxCategoryUpdateBuilder.of().actions(batch).version(updatedTaxCategory.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

