/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyTypesGet;
import com.commercetools.api.client.ByProjectKeyTypesKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyTypesPost;
import com.commercetools.api.models.type.Type;
import com.commercetools.api.models.type.TypeDraft;
import com.commercetools.api.models.type.TypePagedQueryResponse;
import com.commercetools.api.models.type.TypeUpdateAction;
import com.commercetools.api.models.type.TypeUpdateBuilder;
import com.commercetools.api.predicates.query.type.TypeQueryBuilderDsl;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.BaseService;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypeServiceImpl
extends BaseService<BaseSyncOptions, Type, TypeDraft, ByProjectKeyTypesGet, TypePagedQueryResponse, ByProjectKeyTypesKeyByKeyGet, Type, TypeQueryBuilderDsl, ByProjectKeyTypesPost>
implements TypeService {
    public TypeServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> typeKeys) {
        return super.cacheKeysToIdsUsingGraphQl(typeKeys, GraphQlQueryResource.TYPES);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> fetchTypeByKey(@Nullable String key) {
        return super.fetchResource(key, this.syncOptions.getCtpClient().types().withKey(key).get());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTypeId(@Nonnull String key) {
        ByProjectKeyTypesGet query = this.syncOptions.getCtpClient().types().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return super.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Type>> fetchMatchingTypesByKeys(@Nonnull Set<String> keys) {
        return super.fetchMatchingResources(keys, type -> type.getKey(), keysNotCached -> this.syncOptions.getCtpClient().types().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> createType(@Nonnull TypeDraft typeDraft) {
        return super.createResource(typeDraft, TypeDraft::getKey, typeResult -> typeResult.getId(), type -> type, () -> this.syncOptions.getCtpClient().types().post(typeDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<Type> updateType(@Nonnull Type type, @Nonnull List<TypeUpdateAction> updateActions) {
        List<List<TypeUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)type));
        for (List<TypeUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedType -> this.syncOptions.getCtpClient().types().withId(updatedType.getId()).post(TypeUpdateBuilder.of().actions(batch).version(updatedType.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

