/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.customer.CustomerResourceIdentifier;
import com.commercetools.api.models.customer.CustomerResourceIdentifierBuilder;
import com.commercetools.api.models.shopping_list.ShoppingList;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListDraftBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListLineItem;
import com.commercetools.api.models.shopping_list.ShoppingListLineItemDraft;
import com.commercetools.api.models.shopping_list.ShoppingListLineItemDraftBuilder;
import com.commercetools.api.models.shopping_list.TextLineItem;
import com.commercetools.api.models.shopping_list.TextLineItemDraft;
import com.commercetools.api.models.shopping_list.TextLineItemDraftBuilder;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ShoppingListReferenceResolutionUtils {
    @Nonnull
    public static List<ShoppingListDraft> mapToShoppingListDrafts(@Nonnull List<ShoppingList> shoppingLists, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return shoppingLists.stream().filter(Objects::nonNull).map(shoppingList -> ShoppingListReferenceResolutionUtils.mapToShoppingListDraft(shoppingList, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    public static ShoppingListDraft mapToShoppingListDraft(@Nonnull ShoppingList shoppingList, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        CustomerResourceIdentifier resourceIdentifierWithKey = SyncUtils.getResourceIdentifierWithKey((Reference)shoppingList.getCustomer(), referenceIdToKeyCache, (id, key) -> CustomerResourceIdentifierBuilder.of().id(id).key(key).build());
        return ShoppingListDraftBuilder.of().name(shoppingList.getName()).description(shoppingList.getDescription()).key(shoppingList.getKey()).customer(resourceIdentifierWithKey).slug(shoppingList.getSlug()).lineItems(ShoppingListReferenceResolutionUtils.mapToLineItemDrafts(shoppingList.getLineItems(), referenceIdToKeyCache)).textLineItems(ShoppingListReferenceResolutionUtils.mapToTextLineItemDrafts(shoppingList.getTextLineItems(), referenceIdToKeyCache)).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(shoppingList, referenceIdToKeyCache)).deleteDaysAfterLastModification(shoppingList.getDeleteDaysAfterLastModification()).anonymousId(shoppingList.getAnonymousId()).build();
    }

    private static List<ShoppingListLineItemDraft> mapToLineItemDrafts(@Nullable List<ShoppingListLineItem> lineItems, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (lineItems == null) {
            return List.of();
        }
        return lineItems.stream().filter(Objects::nonNull).map(lineItem -> ShoppingListReferenceResolutionUtils.mapToLineItemDraft(lineItem, referenceIdToKeyCache)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static ShoppingListLineItemDraft mapToLineItemDraft(@Nonnull ShoppingListLineItem lineItem, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (lineItem.getVariant() != null) {
            return ShoppingListLineItemDraftBuilder.of().sku(lineItem.getVariant().getSku()).quantity(lineItem.getQuantity()).addedAt(lineItem.getAddedAt()).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(lineItem.getCustom(), referenceIdToKeyCache)).build();
        }
        return null;
    }

    private static List<TextLineItemDraft> mapToTextLineItemDrafts(@Nullable List<TextLineItem> textLineItems, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (textLineItems == null) {
            return List.of();
        }
        return textLineItems.stream().filter(Objects::nonNull).map(textLineItem -> ShoppingListReferenceResolutionUtils.mapToTextLineItemDraft(textLineItem, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static TextLineItemDraft mapToTextLineItemDraft(@Nonnull TextLineItem textLineItem, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return TextLineItemDraftBuilder.of().name(textLineItem.getName()).quantity(textLineItem.getQuantity()).description(textLineItem.getDescription()).addedAt(textLineItem.getAddedAt()).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(textLineItem.getCustom(), referenceIdToKeyCache)).build();
    }

    private ShoppingListReferenceResolutionUtils() {
    }
}

