/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.api.models.shopping_list.ShoppingList;
import com.commercetools.api.models.shopping_list.ShoppingListChangeNameActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListSetAnonymousIdActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListSetCustomerActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListSetDeleteDaysAfterLastModificationActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListSetDescriptionActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListSetSlugActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ShoppingListUpdateActionUtils {
    private ShoppingListUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetSlugUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getSlug(), newShoppingList.getSlug(), () -> ShoppingListSetSlugActionBuilder.of().slug(newShoppingList.getSlug()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildChangeNameUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getName(), newShoppingList.getName(), () -> ShoppingListChangeNameActionBuilder.of().name(newShoppingList.getName()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetDescriptionUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getDescription(), newShoppingList.getDescription(), () -> ShoppingListSetDescriptionActionBuilder.of().description(newShoppingList.getDescription()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetCustomerUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldShoppingList.getCustomer(), newShoppingList.getCustomer(), () -> ShoppingListSetCustomerActionBuilder.of().customer(newShoppingList.getCustomer()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetAnonymousIdUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getAnonymousId(), newShoppingList.getAnonymousId(), () -> ShoppingListSetAnonymousIdActionBuilder.of().anonymousId(newShoppingList.getAnonymousId()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetDeleteDaysAfterLastModificationUpdateAction(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldShoppingList.getDeleteDaysAfterLastModification(), newShoppingList.getDeleteDaysAfterLastModification(), () -> ShoppingListSetDeleteDaysAfterLastModificationActionBuilder.of().deleteDaysAfterLastModification(newShoppingList.getDeleteDaysAfterLastModification()).build());
    }
}

