/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.api.models.shopping_list.ShoppingList;
import com.commercetools.api.models.shopping_list.ShoppingListAddTextLineItemAction;
import com.commercetools.api.models.shopping_list.ShoppingListAddTextLineItemActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListChangeTextLineItemNameActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListChangeTextLineItemQuantityActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListRemoveTextLineItemActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListSetTextLineItemDescriptionActionBuilder;
import com.commercetools.api.models.shopping_list.ShoppingListUpdateAction;
import com.commercetools.api.models.shopping_list.TextLineItem;
import com.commercetools.api.models.shopping_list.TextLineItemDraft;
import com.commercetools.api.models.type.ResourceTypeId;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.models.TextLineItemCustomTypeAdapter;
import com.commercetools.sync.shoppinglists.models.TextLineItemDraftCustomTypeAdapter;
import com.commercetools.sync.shoppinglists.utils.TextLineItemCustomActionBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;

public final class TextLineItemUpdateActionUtils {
    @Nonnull
    public static List<ShoppingListUpdateAction> buildTextLineItemsUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull ShoppingListSyncOptions syncOptions) {
        boolean hasNewTextLineItems;
        boolean hasOldTextLineItems = oldShoppingList.getTextLineItems() != null && !oldShoppingList.getTextLineItems().isEmpty();
        boolean bl = hasNewTextLineItems = newShoppingList.getTextLineItems() != null && !newShoppingList.getTextLineItems().isEmpty() && newShoppingList.getTextLineItems().stream().anyMatch(Objects::nonNull);
        if (hasOldTextLineItems && !hasNewTextLineItems) {
            return oldShoppingList.getTextLineItems().stream().map(textLineItem -> ShoppingListRemoveTextLineItemActionBuilder.of().textLineItemId(textLineItem.getId()).build()).collect(Collectors.toList());
        }
        if (!hasOldTextLineItems) {
            if (!hasNewTextLineItems) {
                return Collections.emptyList();
            }
            return newShoppingList.getTextLineItems().stream().filter(Objects::nonNull).filter(TextLineItemUpdateActionUtils::hasQuantity).map(TextLineItemUpdateActionUtils::mapToAddTextLineItemAction).collect(Collectors.toList());
        }
        List oldTextLineItems = oldShoppingList.getTextLineItems();
        List<TextLineItemDraft> newTextLineItems = newShoppingList.getTextLineItems().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return TextLineItemUpdateActionUtils.buildUpdateActions(oldShoppingList, newShoppingList, oldTextLineItems, newTextLineItems, syncOptions);
    }

    private static boolean hasQuantity(@Nonnull TextLineItemDraft textLineItemDraft) {
        return textLineItemDraft.getQuantity() != null && textLineItemDraft.getQuantity() > 0L;
    }

    @Nonnull
    private static List<ShoppingListUpdateAction> buildUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull List<TextLineItem> oldTextLineItems, @Nonnull List<TextLineItemDraft> newTextLineItems, @Nonnull ShoppingListSyncOptions syncOptions) {
        int i;
        ArrayList<ShoppingListUpdateAction> updateActions = new ArrayList<ShoppingListUpdateAction>();
        int minSize = Math.min(oldTextLineItems.size(), newTextLineItems.size());
        for (i = 0; i < minSize; ++i) {
            TextLineItem oldTextLineItem = oldTextLineItems.get(i);
            TextLineItemDraft newTextLineItem = newTextLineItems.get(i);
            if (newTextLineItem.getName() == null || newTextLineItem.getName().getLocales().isEmpty()) {
                syncOptions.applyErrorCallback(new SyncException(String.format("TextLineItemDraft at position '%d' of the ShoppingListDraft with key '%s' has no name set. Please make sure all text line items have names.", i, newShoppingList.getKey())), oldShoppingList, newShoppingList, updateActions);
                return Collections.emptyList();
            }
            updateActions.addAll(TextLineItemUpdateActionUtils.buildTextLineItemUpdateActions(oldShoppingList, newShoppingList, oldTextLineItem, newTextLineItem, syncOptions));
        }
        for (i = minSize; i < oldTextLineItems.size(); ++i) {
            updateActions.add((ShoppingListUpdateAction)ShoppingListRemoveTextLineItemActionBuilder.of().textLineItemId(oldTextLineItems.get(i).getId()).build());
        }
        for (i = minSize; i < newTextLineItems.size(); ++i) {
            if (!TextLineItemUpdateActionUtils.hasQuantity(newTextLineItems.get(i))) continue;
            updateActions.add((ShoppingListUpdateAction)TextLineItemUpdateActionUtils.mapToAddTextLineItemAction(newTextLineItems.get(i)));
        }
        return updateActions;
    }

    @Nonnull
    private static ShoppingListAddTextLineItemAction mapToAddTextLineItemAction(@Nonnull TextLineItemDraft textLineItemDraft) {
        return ShoppingListAddTextLineItemActionBuilder.of().name(textLineItemDraft.getName()).description(textLineItemDraft.getDescription()).quantity(textLineItemDraft.getQuantity()).addedAt(textLineItemDraft.getAddedAt()).custom(textLineItemDraft.getCustom()).build();
    }

    @Nonnull
    public static List<ShoppingListUpdateAction> buildTextLineItemUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        List<ShoppingListUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(TextLineItemUpdateActionUtils.buildChangeTextLineItemNameUpdateAction(oldTextLineItem, newTextLineItem), TextLineItemUpdateActionUtils.buildSetTextLineItemDescriptionUpdateAction(oldTextLineItem, newTextLineItem), TextLineItemUpdateActionUtils.buildChangeTextLineItemQuantityUpdateAction(oldTextLineItem, newTextLineItem));
        updateActions.addAll(TextLineItemUpdateActionUtils.buildTextLineItemCustomUpdateActions(oldShoppingList, newShoppingList, oldTextLineItem, newTextLineItem, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildChangeTextLineItemNameUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getName(), newTextLineItem.getName(), () -> ShoppingListChangeTextLineItemNameActionBuilder.of().textLineItemId(oldTextLineItem.getId()).name(newTextLineItem.getName()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildSetTextLineItemDescriptionUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getDescription(), newTextLineItem.getDescription(), () -> ShoppingListSetTextLineItemDescriptionActionBuilder.of().description(newTextLineItem.getDescription()).textLineItemId(oldTextLineItem.getId()).build());
    }

    @Nonnull
    public static Optional<ShoppingListUpdateAction> buildChangeTextLineItemQuantityUpdateAction(@Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem) {
        Long newTextLineItemQuantity = newTextLineItem.getQuantity() == null ? NumberUtils.LONG_ONE : newTextLineItem.getQuantity();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTextLineItem.getQuantity(), newTextLineItemQuantity, () -> ShoppingListChangeTextLineItemQuantityActionBuilder.of().textLineItemId(oldTextLineItem.getId()).quantity(newTextLineItemQuantity).build());
    }

    @Nonnull
    public static List<ShoppingListUpdateAction> buildTextLineItemCustomUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull TextLineItem oldTextLineItem, @Nonnull TextLineItemDraft newTextLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(newShoppingList, TextLineItemCustomTypeAdapter.of(oldTextLineItem), TextLineItemDraftCustomTypeAdapter.of(newTextLineItem), new TextLineItemCustomActionBuilder(), null, t -> oldTextLineItem.getId(), textLineItem -> ResourceTypeId.SHOPPING_LIST_TEXT_LINE_ITEM.getJsonName(), t -> oldTextLineItem.getId(), syncOptions);
    }

    private TextLineItemUpdateActionUtils() {
    }
}

