/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.state.State;
import com.commercetools.api.models.state.StateDraft;
import com.commercetools.api.models.state.StateDraftBuilder;
import com.commercetools.api.models.state.StateResourceIdentifier;
import com.commercetools.api.models.state.StateResourceIdentifierBuilder;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class StateReferenceResolutionUtils {
    @Nonnull
    public static List<StateDraft> mapToStateDrafts(@Nonnull List<State> states, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return states.stream().filter(Objects::nonNull).map(state -> {
            List<StateResourceIdentifier> newTransitions = StateReferenceResolutionUtils.replaceTransitionIdsWithKeys(state, referenceIdToKeyCache);
            return StateReferenceResolutionUtils.getStateDraft(state, newTransitions);
        }).collect(Collectors.toList());
    }

    private static StateDraft getStateDraft(State state, List<StateResourceIdentifier> newTransitions) {
        if (state.getKey() != null && state.getType() != null) {
            return StateDraftBuilder.of().key(state.getKey()).type(state.getType()).name(state.getName()).description(state.getDescription()).initial(state.getInitial()).roles(state.getRoles()).transitions(newTransitions).build();
        }
        return StateDraft.of();
    }

    private static List<StateResourceIdentifier> replaceTransitionIdsWithKeys(@Nonnull State state, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        List transitions = state.getTransitions();
        if (transitions == null) {
            return null;
        }
        ArrayList<StateResourceIdentifier> newTransitions = new ArrayList<StateResourceIdentifier>();
        if (!transitions.isEmpty()) {
            transitions.forEach(transition -> newTransitions.add(SyncUtils.getResourceIdentifierWithKey((Reference)transition, referenceIdToKeyCache, (id, key) -> StateResourceIdentifierBuilder.of().id(id).key(referenceIdToKeyCache.get(transition.getId())).build())));
        }
        return newTransitions;
    }

    private StateReferenceResolutionUtils() {
    }
}

