/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.api.models.type.CustomFieldEnumValue;
import com.commercetools.api.models.type.TypeAddEnumValueActionBuilder;
import com.commercetools.api.models.type.TypeChangeEnumValueLabelActionBuilder;
import com.commercetools.api.models.type.TypeChangeEnumValueOrderActionBuilder;
import com.commercetools.api.models.type.TypeUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.EnumValuesUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class PlainEnumValueUpdateActionUtils {
    @Nonnull
    static List<TypeUpdateAction> buildEnumValuesUpdateActions(@Nonnull String fieldDefinitionName, @Nonnull List<CustomFieldEnumValue> oldEnumValues, @Nullable List<CustomFieldEnumValue> newEnumValues) {
        return EnumValuesUpdateActionUtils.buildActions(fieldDefinitionName, oldEnumValues, newEnumValues, null, (definitionName, oldEnumValue, newEnumValue) -> PlainEnumValueUpdateActionUtils.buildLocalizedEnumValueUpdateActions(definitionName, oldEnumValue, newEnumValue), (name, enumValue) -> TypeAddEnumValueActionBuilder.of().fieldName(name).value(enumValue).build(), null, (name, enumValues) -> TypeChangeEnumValueOrderActionBuilder.of().fieldName(name).keys(enumValues).build());
    }

    @Nonnull
    public static List<TypeUpdateAction> buildLocalizedEnumValueUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull CustomFieldEnumValue oldEnumValue, @Nonnull CustomFieldEnumValue newEnumValue) {
        return OptionalUtils.filterEmptyOptionals(PlainEnumValueUpdateActionUtils.buildChangeLabelAction(attributeDefinitionName, oldEnumValue, newEnumValue));
    }

    @Nonnull
    private static Optional<TypeUpdateAction> buildChangeLabelAction(@Nonnull String attributeDefinitionName, @Nonnull CustomFieldEnumValue oldEnumValue, @Nonnull CustomFieldEnumValue newEnumValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldEnumValue.getLabel(), newEnumValue.getLabel(), () -> TypeChangeEnumValueLabelActionBuilder.of().fieldName(attributeDefinitionName).value(newEnumValue).build());
    }

    private PlainEnumValueUpdateActionUtils() {
    }
}

