/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.service.impl;

import com.commercetools.sync.categories.service.CategoryTransformService;
import com.commercetools.sync.categories.utils.CategoryReferenceResolutionUtils;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CategoryTransformServiceImpl
extends BaseTransformServiceImpl
implements CategoryTransformService {
    public CategoryTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<CategoryDraft>> toCategoryDrafts(@Nonnull List<Category> categories) {
        this.cacheResourceReferenceKeys(categories);
        ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
        transformReferencesToRunParallel.add(this.transformParentCategoryReference(categories));
        transformReferencesToRunParallel.add(this.transformCustomTypeReference(categories));
        return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> CategoryReferenceResolutionUtils.mapToCategoryDrafts(categories, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformParentCategoryReference(@Nonnull List<Category> categories) {
        Set<String> parentCategoryIds = categories.stream().map(Category::getParent).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(parentCategoryIds, GraphQlQueryResources.CATEGORIES);
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<Category> categories) {
        HashSet<String> setOfTypeIds = new HashSet<String>();
        setOfTypeIds.addAll(categories.stream().map(Category::getCustom).filter(Objects::nonNull).map(customFields -> customFields.getType().getId()).collect(Collectors.toSet()));
        setOfTypeIds.addAll(categories.stream().map(Category::getAssets).map(assets -> assets.stream().filter(Objects::nonNull).map(Asset::getCustom).filter(Objects::nonNull).map(customFields -> customFields.getType().getId()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet()));
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }
}

