/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.commons.utils.AssetReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.CategoryDraftBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CategoryReferenceResolutionUtils {
    private CategoryReferenceResolutionUtils() {
    }

    @Nonnull
    public static List<CategoryDraft> mapToCategoryDrafts(@Nonnull List<Category> categories, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return categories.stream().map(category -> CategoryReferenceResolutionUtils.mapToCategoryDraft(category, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CategoryDraft mapToCategoryDraft(@Nonnull Category category, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return ((CategoryDraftBuilder)((CategoryDraftBuilder)((CategoryDraftBuilder)CategoryDraftBuilder.of((Category)category).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(category, referenceIdToKeyCache))).assets(AssetReferenceResolutionUtils.mapToAssetDrafts(category.getAssets(), referenceIdToKeyCache))).parent(SyncUtils.getResourceIdentifierWithKey(category.getParent(), referenceIdToKeyCache))).build();
    }
}

