/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryCustomActionBuilder;
import com.commercetools.sync.categories.utils.CategoryUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import javax.annotation.Nonnull;

public final class CategorySyncUtils {
    private static final CategoryCustomActionBuilder categoryCustomActionBuilder = new CategoryCustomActionBuilder();

    @Nonnull
    public static List<UpdateAction<Category>> buildActions(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        List<UpdateAction<Category>> updateActions = OptionalUtils.filterEmptyOptionals(CategoryUpdateActionUtils.buildChangeNameUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildChangeSlugUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetExternalIdUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetDescriptionUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildChangeParentUpdateAction(oldCategory, newCategory, syncOptions), CategoryUpdateActionUtils.buildChangeOrderHintUpdateAction(oldCategory, newCategory, syncOptions), CategoryUpdateActionUtils.buildSetMetaTitleUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetMetaDescriptionUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetMetaKeywordsUpdateAction(oldCategory, newCategory));
        List<UpdateAction<Category>> categoryCustomUpdateActions = CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(oldCategory, newCategory, categoryCustomActionBuilder, syncOptions);
        List<UpdateAction<Category>> assetsUpdateActions = CategoryUpdateActionUtils.buildAssetsUpdateActions(oldCategory, newCategory, syncOptions);
        updateActions.addAll(categoryCustomUpdateActions);
        updateActions.addAll(assetsUpdateActions);
        return updateActions;
    }

    private CategorySyncUtils() {
    }
}

