/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.models.GraphQlBaseRequest;
import com.commercetools.sync.commons.models.GraphQlBaseResource;
import com.commercetools.sync.commons.models.GraphQlBaseResult;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.client.HttpRequestIntent;
import io.sphere.sdk.http.HttpMethod;
import io.sphere.sdk.http.HttpResponse;
import io.sphere.sdk.json.SphereJsonUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GraphQlBaseRequestImpl<T extends GraphQlBaseResult<? extends GraphQlBaseResource>>
implements GraphQlBaseRequest<T> {
    protected String queryPredicate = null;
    protected long limit = 500L;

    @Override
    @Nonnull
    public GraphQlBaseRequest<T> withPredicate(String predicate) {
        this.queryPredicate = predicate;
        return this;
    }

    @Override
    @Nonnull
    public GraphQlBaseRequest<T> withLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public HttpRequestIntent httpRequestIntent() {
        String body = String.format("{\"query\": \"{%s}\"}", this.buildQueryString());
        return HttpRequestIntent.of((HttpMethod)HttpMethod.POST, (String)"/graphql", (String)body);
    }

    @Nullable
    public T deserializeWithResourceName(@Nonnull HttpResponse httpResponse, @Nonnull String resourceName, @Nonnull Class<T> clazz) {
        JsonNode rootJsonNode = SphereJsonUtils.parse((byte[])httpResponse.getResponseBody());
        if (rootJsonNode.isNull()) {
            return null;
        }
        JsonNode result = rootJsonNode.get("data").get(resourceName);
        return (T)((GraphQlBaseResult)SphereJsonUtils.readObject((JsonNode)result, clazz));
    }

    protected abstract String buildQueryString();
}

