/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.models.GraphQlBaseResource;
import com.commercetools.sync.commons.models.GraphQlBaseResult;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.queries.PagedQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ChunkUtils {
    public static <T, Q extends SphereRequest<T>> CompletableFuture<List<T>> executeChunks(@Nonnull SphereClient client, @Nonnull List<Q> requests) {
        List futures = requests.stream().map(request -> client.execute(request).toCompletableFuture()).collect(Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }

    public static <T> List<T> flattenPagedQueryResults(@Nonnull List<PagedQueryResult<T>> pagedQueryResults) {
        return pagedQueryResults.stream().map(PagedQueryResult::getResults).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T extends GraphQlBaseResult<U>, U extends GraphQlBaseResource> Set<U> flattenGraphQLBaseResults(@Nonnull List<T> graphQlBaseResults) {
        return graphQlBaseResults.stream().map(GraphQlBaseResult::getResults).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static <T> List<List<T>> chunk(@Nonnull Collection<T> elements, int chunkSize) {
        AtomicInteger index = new AtomicInteger(0);
        return new ArrayList<List<T>>(elements.stream().collect(Collectors.groupingBy(x -> index.getAndIncrement() / chunkSize)).values());
    }
}

