/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.helpers.CustomerBatchValidator;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.customers.CustomerDraft;
import io.sphere.sdk.customers.CustomerDraftBuilder;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CustomerReferenceResolver
extends CustomReferenceResolver<CustomerDraft, CustomerDraftBuilder, CustomerSyncOptions> {
    public static final String FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE = "Failed to resolve customer group resource identifier on CustomerDraft with key:'%s'. Reason: %s";
    public static final String FAILED_TO_RESOLVE_STORE_REFERENCE = "Failed to resolve store resource identifier on CustomerDraft with key:'%s'. Reason: %s";
    public static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CustomerDraft with key:'%s'.";
    public static final String CUSTOMER_GROUP_DOES_NOT_EXIST = "CustomerGroup with key '%s' doesn't exist.";
    private final TypeService typeService;
    private final CustomerGroupService customerGroupService;

    public CustomerReferenceResolver(@Nonnull CustomerSyncOptions options, @Nonnull TypeService typeService, @Nonnull CustomerGroupService customerGroupService) {
        super(options, typeService);
        this.typeService = typeService;
        this.customerGroupService = customerGroupService;
    }

    @Override
    @Nonnull
    public CompletionStage<CustomerDraft> resolveReferences(@Nonnull CustomerDraft customerDraft) {
        return this.resolveCustomTypeReference(CustomerDraftBuilder.of((CustomerDraft)customerDraft)).thenCompose(this::resolveCustomerGroupReference).thenCompose(this::resolveStoreReferences).thenApply(rec$ -> ((CustomerDraftBuilder)rec$).build());
    }

    @Override
    protected CompletionStage<CustomerDraftBuilder> resolveCustomTypeReference(@Nonnull CustomerDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, rec$ -> ((CustomerDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (CustomerDraftBuilder)((CustomerDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    public CompletionStage<CustomerDraftBuilder> resolveCustomerGroupReference(@Nonnull CustomerDraftBuilder draftBuilder) {
        ResourceIdentifier customerGroupResourceIdentifier = draftBuilder.getCustomerGroup();
        if (customerGroupResourceIdentifier != null && customerGroupResourceIdentifier.getId() == null) {
            String customerGroupKey;
            try {
                customerGroupKey = CustomerReferenceResolver.getKeyFromResourceIdentifier(customerGroupResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveCustomerGroupReference(draftBuilder, customerGroupKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<CustomerDraftBuilder> fetchAndResolveCustomerGroupReference(@Nonnull CustomerDraftBuilder draftBuilder, @Nonnull String customerGroupKey) {
        return this.customerGroupService.fetchCachedCustomerGroupId(customerGroupKey).thenCompose(resolvedCustomerGroupIdOptional -> resolvedCustomerGroupIdOptional.map(resolvedCustomerGroupId -> CompletableFuture.completedFuture(draftBuilder.customerGroup(CustomerGroup.referenceOfId((String)resolvedCustomerGroupId).toResourceIdentifier()))).orElseGet(() -> {
            String errorMessage = String.format(CUSTOMER_GROUP_DOES_NOT_EXIST, customerGroupKey);
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE, draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Nonnull
    public CompletionStage<CustomerDraftBuilder> resolveStoreReferences(@Nonnull CustomerDraftBuilder draftBuilder) {
        List storeResourceIdentifiers = draftBuilder.getStores();
        if (storeResourceIdentifiers == null || storeResourceIdentifiers.isEmpty()) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        ArrayList<ResourceIdentifier> resolvedReferences = new ArrayList<ResourceIdentifier>();
        for (ResourceIdentifier storeResourceIdentifier : storeResourceIdentifiers) {
            if (storeResourceIdentifier == null) continue;
            if (storeResourceIdentifier.getId() == null) {
                try {
                    String storeKey = CustomerReferenceResolver.getKeyFromResourceIdentifier(storeResourceIdentifier);
                    resolvedReferences.add(ResourceIdentifier.ofKey((String)storeKey));
                    continue;
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_STORE_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
                }
            }
            resolvedReferences.add(ResourceIdentifier.ofId((String)storeResourceIdentifier.getId()));
        }
        return CompletableFuture.completedFuture(draftBuilder.stores(resolvedReferences));
    }

    @Nonnull
    public CompletableFuture<List<Map<String, String>>> populateKeyToIdCachesForReferencedKeys(@Nonnull CustomerBatchValidator.ReferencedKeys referencedKeys) {
        Set<String> customerGroupKeys;
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        Set<String> typeKeys = referencedKeys.getTypeKeys();
        if (!typeKeys.isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        if (!(customerGroupKeys = referencedKeys.getCustomerGroupKeys()).isEmpty()) {
            futures.add(this.customerGroupService.cacheKeysToIds(customerGroupKeys));
        }
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }
}

