/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products;

import com.commercetools.sync.products.ActionGroup;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class SyncFilter {
    private final Set<ActionGroup> actionGroups;
    private final boolean includeOnly;
    private static SyncFilter defaultSyncFilter = null;

    private SyncFilter(boolean includeOnly, @Nonnull ActionGroup[] actionGroups) {
        this.includeOnly = includeOnly;
        this.actionGroups = new HashSet<ActionGroup>(Arrays.asList(actionGroups));
    }

    private SyncFilter() {
        this.includeOnly = false;
        this.actionGroups = Collections.emptySet();
    }

    @Nonnull
    public static SyncFilter ofWhiteList(ActionGroup ... actionGroups) {
        return new SyncFilter(true, actionGroups);
    }

    @Nonnull
    public static SyncFilter ofBlackList(ActionGroup ... actionGroups) {
        return new SyncFilter(false, actionGroups);
    }

    @Nonnull
    public static SyncFilter of() {
        defaultSyncFilter = Optional.ofNullable(defaultSyncFilter).orElseGet(SyncFilter::new);
        return defaultSyncFilter;
    }

    public boolean filterActionGroup(@Nonnull ActionGroup actionGroup) {
        return this.includeOnly == this.actionGroups.contains((Object)actionGroup);
    }
}

