/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.helpers;

import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.states.StateSyncOptions;
import com.commercetools.sync.states.helpers.StateSyncStatistics;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class StateBatchValidator
extends BaseBatchValidator<StateDraft, StateSyncOptions, StateSyncStatistics> {
    static final String STATE_DRAFT_KEY_NOT_SET = "StateDraft with name: %s doesn't have a key. Please make sure all state drafts have keys.";
    static final String STATE_DRAFT_IS_NULL = "StateDraft is null.";
    static final String STATE_HAS_INVALID_REFERENCES = "StateDraft with key: '%s' has invalid state transitions";

    public StateBatchValidator(@Nonnull StateSyncOptions syncOptions, @Nonnull StateSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<StateDraft>, Set<String>> validateAndCollectReferencedKeys(@Nonnull List<StateDraft> stateDrafts) {
        HashSet stateTransitionKeys = new HashSet();
        Set validDrafts = stateDrafts.stream().filter(stateDraft -> this.isValidStateDraft((StateDraft)stateDraft, stateTransitionKeys)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, stateTransitionKeys);
    }

    private boolean isValidStateDraft(@Nullable StateDraft stateDraft, @Nonnull Set<String> stateTransitionKeys) {
        if (stateDraft == null) {
            this.handleError(STATE_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)stateDraft.getKey())) {
            this.handleError(String.format(STATE_DRAFT_KEY_NOT_SET, stateDraft.getName()));
        } else {
            try {
                Set<String> referencesStateKeys = StateBatchValidator.getTransitionKeys(stateDraft);
                stateTransitionKeys.addAll(referencesStateKeys);
                return true;
            }
            catch (SyncException exception) {
                this.handleError(exception);
            }
        }
        return false;
    }

    @Nonnull
    private static Set<String> getTransitionKeys(@Nonnull StateDraft stateDraft) throws SyncException {
        Set transitions = stateDraft.getTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> referencedStateKeys = new HashSet<String>();
        ArrayList<Reference> invalidStates = new ArrayList<Reference>();
        for (Reference transition : transitions) {
            if (transition == null) continue;
            try {
                referencedStateKeys.add(StateBatchValidator.getStateKey((Reference<State>)transition));
            }
            catch (InvalidReferenceException invalidReferenceException) {
                invalidStates.add(transition);
            }
        }
        if (!invalidStates.isEmpty()) {
            String errorMessage = String.format(STATE_HAS_INVALID_REFERENCES, stateDraft.getKey());
            throw new SyncException(errorMessage, new InvalidReferenceException("The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource."));
        }
        return referencedStateKeys;
    }

    @Nonnull
    private static String getStateKey(@Nonnull Reference<State> stateReference) throws InvalidReferenceException {
        String key = stateReference.getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new InvalidReferenceException("The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource.");
        }
        return key;
    }
}

