/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories.helpers;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.taxcategories.TaxCategorySyncOptions;
import com.commercetools.sync.taxcategories.helpers.TaxCategorySyncStatistics;
import io.sphere.sdk.taxcategories.TaxCategoryDraft;
import io.sphere.sdk.taxcategories.TaxRateDraft;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TaxCategoryBatchValidator
extends BaseBatchValidator<TaxCategoryDraft, TaxCategorySyncOptions, TaxCategorySyncStatistics> {
    static final String TAX_CATEGORY_DRAFT_KEY_NOT_SET = "TaxCategoryDraft with name: %s doesn't have a key. Please make sure all tax category drafts have keys.";
    static final String TAX_CATEGORY_DRAFT_IS_NULL = "TaxCategoryDraft is null.";
    static final String TAX_CATEGORY_DUPLICATED_COUNTRY = "Tax rate drafts have duplicated country codes. Duplicated tax rate country code: '%s'. Tax rate country codes and states are expected to be unique inside their tax category.";
    static final String TAX_CATEGORY_DUPLICATED_COUNTRY_AND_STATE = "Tax rate drafts have duplicated country codes and states. Duplicated tax rate country code: '%s'. state : '%s'. Tax rate country codes and states are expected to be unique inside their tax category.";

    public TaxCategoryBatchValidator(@Nonnull TaxCategorySyncOptions syncOptions, @Nonnull TaxCategorySyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<TaxCategoryDraft>, Set<String>> validateAndCollectReferencedKeys(@Nonnull List<TaxCategoryDraft> taxCategoryDrafts) {
        Set validDrafts = taxCategoryDrafts.stream().filter(this::isValidTaxCategoryDraft).collect(Collectors.toSet());
        Set validKeys = validDrafts.stream().map(TaxCategoryDraft::getKey).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, validKeys);
    }

    private boolean isValidTaxCategoryDraft(@Nullable TaxCategoryDraft taxCategoryDraft) {
        if (taxCategoryDraft == null) {
            this.handleError(TAX_CATEGORY_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)taxCategoryDraft.getKey())) {
            this.handleError(String.format(TAX_CATEGORY_DRAFT_KEY_NOT_SET, taxCategoryDraft.getName()));
        } else {
            if (taxCategoryDraft.getTaxRates() != null && !taxCategoryDraft.getTaxRates().isEmpty()) {
                return this.validateIfDuplicateCountryAndState(taxCategoryDraft.getTaxRates());
            }
            return true;
        }
        return false;
    }

    private boolean validateIfDuplicateCountryAndState(List<TaxRateDraft> taxRateDrafts) {
        Map<String, Map<String, Long>> map = taxRateDrafts.stream().collect(Collectors.groupingBy(draft -> Objects.toString(draft.getCountry(), ""), Collectors.groupingBy(draft -> Objects.toString(draft.getState(), ""), Collectors.counting())));
        for (Map.Entry<String, Map<String, Long>> countryEntry : map.entrySet()) {
            for (Map.Entry<String, Long> stateEntry : countryEntry.getValue().entrySet()) {
                if (stateEntry.getValue() <= 1L) continue;
                String errorMessage = StringUtils.isBlank((CharSequence)stateEntry.getKey()) ? String.format(TAX_CATEGORY_DUPLICATED_COUNTRY, countryEntry.getKey()) : String.format(TAX_CATEGORY_DUPLICATED_COUNTRY_AND_STATE, countryEntry.getKey(), stateEntry.getKey());
                this.handleError(new SyncException(errorMessage));
                return false;
            }
        }
        return true;
    }
}

