/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.types.utils.LocalizedEnumValueUpdateActionUtils;
import com.commercetools.sync.types.utils.PlainEnumValueUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.types.EnumFieldType;
import io.sphere.sdk.types.FieldDefinition;
import io.sphere.sdk.types.FieldType;
import io.sphere.sdk.types.LocalizedEnumFieldType;
import io.sphere.sdk.types.SetFieldType;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.commands.updateactions.ChangeFieldDefinitionLabel;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

final class FieldDefinitionUpdateActionUtils {
    @Nonnull
    static List<UpdateAction<Type>> buildActions(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        List<UpdateAction<Type>> updateActions = OptionalUtils.filterEmptyOptionals(FieldDefinitionUpdateActionUtils.buildChangeLabelUpdateAction(oldFieldDefinition, newFieldDefinition));
        updateActions.addAll(FieldDefinitionUpdateActionUtils.buildEnumUpdateActions(oldFieldDefinition, newFieldDefinition));
        return updateActions;
    }

    @Nonnull
    static List<UpdateAction<Type>> buildEnumUpdateActions(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        FieldType oldFieldDefinitionType = oldFieldDefinition.getType();
        FieldType newFieldDefinitionType = newFieldDefinition.getType();
        return FieldDefinitionUpdateActionUtils.getEnumFieldType(oldFieldDefinitionType).map(oldEnumFieldType -> FieldDefinitionUpdateActionUtils.getEnumFieldType(newFieldDefinitionType).map(newEnumFieldType -> PlainEnumValueUpdateActionUtils.buildEnumValuesUpdateActions(oldFieldDefinition.getName(), oldEnumFieldType.getValues(), newEnumFieldType.getValues())).orElseGet(Collections::emptyList)).orElseGet(() -> FieldDefinitionUpdateActionUtils.getLocalizedEnumFieldType(oldFieldDefinitionType).map(oldLocalizedEnumFieldType -> FieldDefinitionUpdateActionUtils.getLocalizedEnumFieldType(newFieldDefinitionType).map(newLocalizedEnumFieldType -> LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValuesUpdateActions(oldFieldDefinition.getName(), oldLocalizedEnumFieldType.getValues(), newLocalizedEnumFieldType.getValues())).orElseGet(Collections::emptyList)).orElseGet(Collections::emptyList));
    }

    private static Optional<EnumFieldType> getEnumFieldType(@Nonnull FieldType fieldType) {
        SetFieldType setFieldType;
        FieldType subType;
        if (fieldType instanceof EnumFieldType) {
            return Optional.of((EnumFieldType)fieldType);
        }
        if (fieldType instanceof SetFieldType && (subType = (setFieldType = (SetFieldType)fieldType).getElementType()) instanceof EnumFieldType) {
            return Optional.of((EnumFieldType)subType);
        }
        return Optional.empty();
    }

    private static Optional<LocalizedEnumFieldType> getLocalizedEnumFieldType(@Nonnull FieldType fieldType) {
        SetFieldType setFieldType;
        FieldType subType;
        if (fieldType instanceof LocalizedEnumFieldType) {
            return Optional.of((LocalizedEnumFieldType)fieldType);
        }
        if (fieldType instanceof SetFieldType && (subType = (setFieldType = (SetFieldType)fieldType).getElementType()) instanceof LocalizedEnumFieldType) {
            return Optional.of((LocalizedEnumFieldType)subType);
        }
        return Optional.empty();
    }

    @Nonnull
    static Optional<UpdateAction<Type>> buildChangeLabelUpdateAction(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldFieldDefinition.getLabel(), newFieldDefinition.getLabel(), () -> ChangeFieldDefinitionLabel.of((String)oldFieldDefinition.getName(), (LocalizedString)newFieldDefinition.getLabel()));
    }

    private FieldDefinitionUpdateActionUtils() {
    }
}

