/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.types.TypeSyncOptions;
import com.commercetools.sync.types.utils.FieldDefinitionsUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.TypeDraft;
import io.sphere.sdk.types.commands.updateactions.ChangeName;
import io.sphere.sdk.types.commands.updateactions.SetDescription;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class TypeUpdateActionUtils {
    @Nonnull
    public static Optional<UpdateAction<Type>> buildChangeNameUpdateAction(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldType.getName(), newType.getName(), () -> ChangeName.of((LocalizedString)newType.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Type>> buildSetDescriptionUpdateAction(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldType.getDescription(), newType.getDescription(), () -> SetDescription.of((LocalizedString)newType.getDescription()));
    }

    @Nonnull
    public static List<UpdateAction<Type>> buildFieldDefinitionsUpdateActions(@Nonnull Type oldType, @Nonnull TypeDraft newType, @Nonnull TypeSyncOptions syncOptions) {
        try {
            return FieldDefinitionsUpdateActionUtils.buildFieldDefinitionsUpdateActions(oldType.getFieldDefinitions(), newType.getFieldDefinitions());
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the field definitions of the type with the key '%s'. Reason: %s", newType.getKey(), exception), exception), oldType, newType, null);
            return Collections.emptyList();
        }
    }

    private TypeUpdateActionUtils() {
    }
}

