/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.AssetCustomActionBuilder;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.commands.updateactions.ChangeAssetName;
import io.sphere.sdk.categories.commands.updateactions.SetAssetDescription;
import io.sphere.sdk.categories.commands.updateactions.SetAssetSources;
import io.sphere.sdk.categories.commands.updateactions.SetAssetTags;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.LocalizedString;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CategoryAssetUpdateActionUtils {
    @Nonnull
    public static <D> List<UpdateAction<Category>> buildActions(@Nonnull D newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull CategorySyncOptions syncOptions) {
        List<UpdateAction<Category>> updateActions = OptionalUtils.filterEmptyOptionals(CategoryAssetUpdateActionUtils.buildChangeAssetNameUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetDescriptionUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetTagsUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetSourcesUpdateAction(oldAsset, newAsset));
        updateActions.addAll(CategoryAssetUpdateActionUtils.buildCustomUpdateActions(newResource, oldAsset, newAsset, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildChangeAssetNameUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getName(), newAsset.getName(), () -> ChangeAssetName.ofKey((String)oldAsset.getKey(), (LocalizedString)newAsset.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetAssetDescriptionUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getDescription(), newAsset.getDescription(), () -> SetAssetDescription.ofKey((String)oldAsset.getKey(), (LocalizedString)newAsset.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetAssetTagsUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getTags(), newAsset.getTags(), () -> SetAssetTags.ofKey((String)oldAsset.getKey(), (Set)newAsset.getTags()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetAssetSourcesUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getSources(), newAsset.getSources(), () -> SetAssetSources.ofKey((String)oldAsset.getKey(), (List)newAsset.getSources()));
    }

    @Nonnull
    public static <D> List<UpdateAction<Category>> buildCustomUpdateActions(@Nonnull D newCategory, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull CategorySyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(newCategory, oldAsset, newAsset, new AssetCustomActionBuilder(), -1, Asset::getId, asset -> Asset.resourceTypeId(), Asset::getKey, syncOptions);
    }

    private CategoryAssetUpdateActionUtils() {
    }
}

