/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.service.impl;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.inventories.service.InventoryEntryTransformService;
import com.commercetools.sync.inventories.utils.InventoryReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.types.CustomFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class InventoryEntryTransformServiceImpl
extends BaseTransformServiceImpl
implements InventoryEntryTransformService {
    public InventoryEntryTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<InventoryEntryDraft>> toInventoryEntryDrafts(@Nonnull List<InventoryEntry> inventoryEntries) {
        ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
        transformReferencesToRunParallel.add(this.transformCustomTypeReference(inventoryEntries));
        transformReferencesToRunParallel.add(this.transformChannelReference(inventoryEntries));
        return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> InventoryReferenceResolutionUtils.mapToInventoryEntryDrafts(inventoryEntries, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<InventoryEntry> inventoryEntries) {
        Set<String> setOfTypeIds = inventoryEntries.stream().map(InventoryEntry::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }

    @Nonnull
    private CompletableFuture<Void> transformChannelReference(@Nonnull List<InventoryEntry> inventoryEntries) {
        Set<String> setOfChannelIds = inventoryEntries.stream().map(InventoryEntry::getSupplyChannel).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(setOfChannelIds, GraphQlQueryResources.CHANNELS);
    }
}

