/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.service.impl;

import com.commercetools.sync.commons.exceptions.ReferenceReplacementException;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.producttypes.service.ProductTypeTransformService;
import com.commercetools.sync.producttypes.utils.ProductTypeReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.attributes.AttributeDefinition;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ProductTypeTransformServiceImpl
extends BaseTransformServiceImpl
implements ProductTypeTransformService {
    public ProductTypeTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<ProductTypeDraft>> toProductTypeDrafts(@Nonnull List<ProductType> productTypes) throws ReferenceReplacementException {
        return this.loadNestedProductTypeReferenceKeys(productTypes).thenApply(ignore -> ProductTypeReferenceResolutionUtils.mapToProductTypeDrafts(productTypes, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> loadNestedProductTypeReferenceKeys(@Nonnull List<ProductType> productTypes) {
        HashSet<String> setOfTypeIds = new HashSet<String>(this.collectNestedReferenceIds(productTypes));
        return super.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.PRODUCT_TYPES);
    }

    private Set<String> collectNestedReferenceIds(@Nonnull List<ProductType> productTypes) {
        return productTypes.stream().map(productType -> productType.getAttributes().stream().filter(Objects::nonNull).map(AttributeDefinition::getAttributeType).map(this::getNestedAttributeId).filter(StringUtils::isNotBlank).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private String getNestedAttributeId(AttributeType attributeType) {
        AttributeType elementType;
        if (attributeType instanceof NestedAttributeType) {
            Reference NestedTypeReference = ((NestedAttributeType)attributeType).getTypeReference();
            if (NestedTypeReference != null) {
                return NestedTypeReference.getId();
            }
        } else if (attributeType instanceof SetAttributeType && (elementType = ((SetAttributeType)attributeType).getElementType()) != null) {
            return this.getNestedAttributeId(elementType);
        }
        return null;
    }
}

