/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.attributes.AttributeDefinition;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraftBuilder;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.ProductTypeDraftBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductTypeReferenceResolutionUtils {
    @Nonnull
    public static List<ProductTypeDraft> mapToProductTypeDrafts(@Nonnull List<ProductType> productTypes, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return productTypes.stream().filter(Objects::nonNull).map(productType -> {
            List<AttributeDefinitionDraft> referenceReplacedAttributeDefinitions = ProductTypeReferenceResolutionUtils.replaceAttributeDefinitionsReferenceIdsWithKeys(productType, referenceIdToKeyCache);
            return ProductTypeDraftBuilder.of((ProductType)productType).attributes(referenceReplacedAttributeDefinitions).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    private static List<AttributeDefinitionDraft> replaceAttributeDefinitionsReferenceIdsWithKeys(@Nonnull ProductType productType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return productType.getAttributes().stream().map(attributeDefinition -> {
            AttributeType attributeType = attributeDefinition.getAttributeType();
            AttributeType referenceReplacedType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference(attributeType, referenceIdToKeyCache);
            return ((AttributeDefinitionDraftBuilder)AttributeDefinitionDraftBuilder.of((AttributeDefinition)attributeDefinition).attributeType(referenceReplacedType)).build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    private static AttributeType replaceIdWithKeyForProductTypeReference(@Nonnull AttributeType attributeType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (attributeType instanceof NestedAttributeType) {
            Reference<ProductType> referenceReplacedNestedType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference((NestedAttributeType)attributeType, referenceIdToKeyCache);
            return NestedAttributeType.of(referenceReplacedNestedType);
        }
        if (attributeType instanceof SetAttributeType) {
            SetAttributeType setAttributeType = (SetAttributeType)attributeType;
            AttributeType elementType = setAttributeType.getElementType();
            AttributeType referenceReplacedElementType = ProductTypeReferenceResolutionUtils.replaceIdWithKeyForProductTypeReference(elementType, referenceIdToKeyCache);
            return SetAttributeType.of((AttributeType)referenceReplacedElementType);
        }
        return attributeType;
    }

    @Nonnull
    private static Reference<ProductType> replaceIdWithKeyForProductTypeReference(@Nonnull NestedAttributeType nestedAttributeType, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        Reference productTypeReference = nestedAttributeType.getTypeReference();
        String productTypeId = productTypeReference.getId();
        String productTypeKey = referenceIdToKeyCache.get(productTypeId);
        if (null != productTypeKey) {
            return ProductType.referenceOfId((String)productTypeKey);
        }
        return productTypeReference;
    }

    private ProductTypeReferenceResolutionUtils() {
    }
}

