/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Versioned;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductLike;
import io.sphere.sdk.products.ProductProjection;
import io.sphere.sdk.products.ProductProjectionType;
import io.sphere.sdk.products.commands.ProductCreateCommand;
import io.sphere.sdk.products.commands.ProductUpdateCommand;
import io.sphere.sdk.products.expansion.ProductProjectionExpansionModel;
import io.sphere.sdk.products.queries.ProductProjectionQuery;
import io.sphere.sdk.products.queries.ProductProjectionQueryModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductServiceImpl
extends BaseServiceWithKey<ProductDraft, Product, ProductProjection, ProductSyncOptions, ProductProjectionQuery, ProductProjectionQueryModel, ProductProjectionExpansionModel<ProductProjection>>
implements ProductService {
    public ProductServiceImpl(@Nonnull ProductSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> getIdFromCacheOrFetch(@Nullable String key) {
        return this.fetchCachedResourceId(key, ProductLike::getKey, () -> ProductProjectionQuery.ofStaged().withPredicates(queryModel -> queryModel.key().is(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> productKeys) {
        return this.cacheKeysToIds(productKeys, keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.PRODUCTS));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ProductProjection>> fetchMatchingProductsByKeys(@Nonnull Set<String> productKeys) {
        return this.fetchMatchingResources(productKeys, ProductProjection::getKey, keysNotCached -> ProductProjectionQuery.ofStaged().withPredicates(queryModel -> queryModel.key().isIn((Iterable)keysNotCached)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductProjection>> fetchProduct(@Nullable String key) {
        return this.fetchResource(key, () -> ProductProjectionQuery.ofStaged().withPredicates(queryModel -> queryModel.key().is(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductProjection>> createProduct(@Nonnull ProductDraft productDraft) {
        return this.createResource(productDraft, ProductCreateCommand::of).thenApply(product -> product.map(opt -> opt.toProjection(ProductProjectionType.STAGED)));
    }

    @Override
    @Nonnull
    public CompletionStage<ProductProjection> updateProduct(@Nonnull ProductProjection productProjection, @Nonnull List<UpdateAction<Product>> updateActions) {
        return this.updateProductAndMapToProductProjection(productProjection, updateActions);
    }

    @Nonnull
    private CompletionStage<ProductProjection> updateProductAndMapToProductProjection(@Nonnull ProductProjection productProjection, @Nonnull List<UpdateAction<Product>> updateActions) {
        List<List<UpdateAction<Product>>> batches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(productProjection);
        for (List<UpdateAction<Product>> batch : batches) {
            resultStage = resultStage.thenCompose(updatedProductProjection -> ((ProductSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)ProductUpdateCommand.of((Versioned)updatedProductProjection, (List)batch)).thenApply(p -> p.toProjection(ProductProjectionType.STAGED)));
        }
        return resultStage;
    }
}

