/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import io.sphere.sdk.shoppinglists.LineItemDraft;
import io.sphere.sdk.shoppinglists.LineItemDraftBuilder;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class LineItemReferenceResolver
extends CustomReferenceResolver<LineItemDraft, LineItemDraftBuilder, ShoppingListSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on LineItemDraft with SKU: '%s'.";

    public LineItemReferenceResolver(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions, @Nonnull TypeService typeService) {
        super(shoppingListSyncOptions, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<LineItemDraft> resolveReferences(@Nonnull LineItemDraft lineItemDraft) {
        return this.resolveCustomTypeReference(LineItemDraftBuilder.of((LineItemDraft)lineItemDraft)).thenApply(rec$ -> ((LineItemDraftBuilder)rec$).build());
    }

    @Override
    @Nonnull
    protected CompletionStage<LineItemDraftBuilder> resolveCustomTypeReference(@Nonnull LineItemDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, rec$ -> ((LineItemDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (LineItemDraftBuilder)((LineItemDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getSku()));
    }
}

