/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.helpers.LineItemReferenceResolver;
import com.commercetools.sync.shoppinglists.helpers.ShoppingListBatchValidator;
import com.commercetools.sync.shoppinglists.helpers.TextLineItemReferenceResolver;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.ShoppingListDraftBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ShoppingListReferenceResolver
extends CustomReferenceResolver<ShoppingListDraft, ShoppingListDraftBuilder, ShoppingListSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOMER_REFERENCE = "Failed to resolve customer resource identifier on ShoppingListDraft with key:'%s'. Reason: %s";
    static final String CUSTOMER_DOES_NOT_EXIST = "Customer with key '%s' doesn't exist.";
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on ShoppingListDraft with key:'%s'. ";
    private final CustomerService customerService;
    private final TypeService typeService;
    private final LineItemReferenceResolver lineItemReferenceResolver;
    private final TextLineItemReferenceResolver textLineItemReferenceResolver;

    public ShoppingListReferenceResolver(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions, @Nonnull CustomerService customerService, @Nonnull TypeService typeService) {
        super(shoppingListSyncOptions, typeService);
        this.lineItemReferenceResolver = new LineItemReferenceResolver(shoppingListSyncOptions, typeService);
        this.textLineItemReferenceResolver = new TextLineItemReferenceResolver(shoppingListSyncOptions, typeService);
        this.customerService = customerService;
        this.typeService = typeService;
    }

    @Override
    @Nonnull
    public CompletionStage<ShoppingListDraft> resolveReferences(@Nonnull ShoppingListDraft shoppingListDraft) {
        return this.resolveCustomerReference(ShoppingListDraftBuilder.of((ShoppingListDraft)shoppingListDraft)).thenCompose(this::resolveCustomTypeReference).thenCompose(this::resolveLineItemReferences).thenCompose(this::resolveTextLineItemReferences).thenApply(rec$ -> ((ShoppingListDraftBuilder)rec$).build());
    }

    @Nonnull
    protected CompletionStage<ShoppingListDraftBuilder> resolveCustomerReference(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        ResourceIdentifier customerResourceIdentifier = draftBuilder.getCustomer();
        if (customerResourceIdentifier != null && customerResourceIdentifier.getId() == null) {
            String customerKey;
            try {
                customerKey = ShoppingListReferenceResolver.getKeyFromResourceIdentifier(customerResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveCustomerReference(draftBuilder, customerKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> fetchAndResolveCustomerReference(@Nonnull ShoppingListDraftBuilder draftBuilder, @Nonnull String customerKey) {
        return this.customerService.fetchCachedCustomerId(customerKey).thenCompose(resolvedCustomerIdOptional -> resolvedCustomerIdOptional.map(resolvedCustomerId -> CompletableFuture.completedFuture((ShoppingListDraftBuilder)draftBuilder.customer(Customer.referenceOfId((String)resolvedCustomerId).toResourceIdentifier()))).orElseGet(() -> {
            String errorMessage = String.format(CUSTOMER_DOES_NOT_EXIST, customerKey);
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_REFERENCE, draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Override
    @Nonnull
    protected CompletionStage<ShoppingListDraftBuilder> resolveCustomTypeReference(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, rec$ -> ((ShoppingListDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (ShoppingListDraftBuilder)((ShoppingListDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> resolveLineItemReferences(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        if (draftBuilder.getLineItems() != null) {
            return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(draftBuilder.getLineItems(), this.lineItemReferenceResolver::resolveReferences, Collectors.toList()).thenApply(x$0 -> (ShoppingListDraftBuilder)draftBuilder.lineItems(x$0));
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ShoppingListDraftBuilder> resolveTextLineItemReferences(@Nonnull ShoppingListDraftBuilder draftBuilder) {
        if (draftBuilder.getTextLineItems() != null) {
            return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(draftBuilder.getTextLineItems(), this.textLineItemReferenceResolver::resolveReferences, Collectors.toList()).thenApply(x$0 -> (ShoppingListDraftBuilder)draftBuilder.textLineItems(x$0));
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    public CompletableFuture<List<Map<String, String>>> populateKeyToIdCachesForReferencedKeys(@Nonnull ShoppingListBatchValidator.ReferencedKeys referencedKeys) {
        Set<String> customerKeys;
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        Set<String> typeKeys = referencedKeys.getTypeKeys();
        if (!typeKeys.isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        if (!(customerKeys = referencedKeys.getCustomerKeys()).isEmpty()) {
            futures.add(this.customerService.cacheKeysToIds(customerKeys));
        }
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }
}

