/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.service.impl;

import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import com.commercetools.sync.shoppinglists.service.ShoppingListTransformService;
import com.commercetools.sync.shoppinglists.utils.ShoppingListReferenceResolutionUtils;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.shoppinglists.LineItem;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.TextLineItem;
import io.sphere.sdk.types.Custom;
import io.sphere.sdk.types.CustomFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ShoppingListTransformServiceImpl
extends BaseTransformServiceImpl
implements ShoppingListTransformService {
    public ShoppingListTransformServiceImpl(@Nonnull SphereClient ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        super(ctpClient, referenceIdToKeyCache);
    }

    @Override
    @Nonnull
    public CompletableFuture<List<ShoppingListDraft>> toShoppingListDrafts(@Nonnull List<ShoppingList> shoppingLists) {
        ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
        transformReferencesToRunParallel.add(this.transformCustomTypeReference(shoppingLists));
        transformReferencesToRunParallel.add(this.transformCustomerReference(shoppingLists));
        return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> ShoppingListReferenceResolutionUtils.mapToShoppingListDrafts(shoppingLists, this.referenceIdToKeyCache));
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<ShoppingList> shoppingLists) {
        HashSet<String> setOfTypeIds = new HashSet<String>();
        Set customTypeIds = shoppingLists.stream().map(Custom::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toSet());
        setOfTypeIds.addAll(customTypeIds);
        setOfTypeIds.addAll(this.collectLineItemCustomTypeIds(shoppingLists));
        setOfTypeIds.addAll(this.collectTextLineItemCustomTypeIds(shoppingLists));
        return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResources.TYPES);
    }

    private Set<String> collectTextLineItemCustomTypeIds(List<ShoppingList> shoppingLists) {
        return shoppingLists.stream().map(ShoppingList::getTextLineItems).map(textLineItems -> textLineItems.stream().filter(Objects::nonNull).map(TextLineItem::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> collectLineItemCustomTypeIds(List<ShoppingList> shoppingLists) {
        return shoppingLists.stream().map(ShoppingList::getLineItems).map(lineItems -> lineItems.stream().filter(Objects::nonNull).map(LineItem::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    private CompletableFuture<Void> transformCustomerReference(@Nonnull List<ShoppingList> shoppingLists) {
        Set<String> customerIds = shoppingLists.stream().map(ShoppingList::getCustomer).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
        return this.fetchAndFillReferenceIdToKeyCache(customerIds, GraphQlQueryResources.CUSTOMERS);
    }
}

