/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public abstract class BaseSyncStatistics {
    private AtomicInteger updated = new AtomicInteger();
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger failed = new AtomicInteger();
    private AtomicInteger processed = new AtomicInteger();
    private long latestBatchStartTime;
    private long latestBatchProcessingTimeInDays;
    private long latestBatchProcessingTimeInHours;
    private long latestBatchProcessingTimeInMinutes;
    private long latestBatchProcessingTimeInSeconds;
    private long latestBatchProcessingTimeInMillis;
    private String latestBatchHumanReadableProcessingTime = "";

    public void startTimer() {
        this.latestBatchStartTime = System.currentTimeMillis();
    }

    public AtomicInteger getUpdated() {
        return this.updated;
    }

    public void incrementUpdated() {
        this.updated.incrementAndGet();
    }

    public void incrementUpdated(int times) {
        this.updated.addAndGet(times);
    }

    public AtomicInteger getCreated() {
        return this.created;
    }

    public void incrementCreated() {
        this.created.incrementAndGet();
    }

    public void incrementCreated(int times) {
        this.created.addAndGet(times);
    }

    public AtomicInteger getProcessed() {
        return this.processed;
    }

    public void incrementProcessed() {
        this.processed.incrementAndGet();
    }

    public void incrementProcessed(int times) {
        this.processed.addAndGet(times);
    }

    public AtomicInteger getFailed() {
        return this.failed;
    }

    public void incrementFailed() {
        this.failed.incrementAndGet();
    }

    public void incrementFailed(int times) {
        this.failed.addAndGet(times);
    }

    public void calculateProcessingTime() {
        this.setProcessingTimeInAllUnits();
        this.setHumanReadableProcessingTime();
    }

    private void setProcessingTimeInAllUnits() {
        this.latestBatchProcessingTimeInMillis = System.currentTimeMillis() - this.latestBatchStartTime;
        this.latestBatchProcessingTimeInDays = TimeUnit.MILLISECONDS.toDays(this.latestBatchProcessingTimeInMillis);
        this.latestBatchProcessingTimeInHours = TimeUnit.MILLISECONDS.toHours(this.latestBatchProcessingTimeInMillis);
        this.latestBatchProcessingTimeInMinutes = TimeUnit.MILLISECONDS.toMinutes(this.latestBatchProcessingTimeInMillis);
        this.latestBatchProcessingTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(this.latestBatchProcessingTimeInMillis);
    }

    private void setHumanReadableProcessingTime() {
        long completeDaysInHours = TimeUnit.DAYS.toHours(this.latestBatchProcessingTimeInDays);
        long completeHoursInMinutes = TimeUnit.HOURS.toMinutes(this.latestBatchProcessingTimeInHours);
        long completeMinutesInSeconds = TimeUnit.MINUTES.toSeconds(this.latestBatchProcessingTimeInMinutes);
        long completeSecondsInMillis = TimeUnit.SECONDS.toMillis(this.latestBatchProcessingTimeInSeconds);
        long remainingHours = this.latestBatchProcessingTimeInHours - completeDaysInHours;
        long remainingMinutes = this.latestBatchProcessingTimeInMinutes - completeHoursInMinutes;
        long remainingSeconds = this.latestBatchProcessingTimeInSeconds - completeMinutesInSeconds;
        long remainingMillis = this.latestBatchProcessingTimeInMillis - completeSecondsInMillis;
        this.latestBatchHumanReadableProcessingTime = String.format("%dd, %dh, %dm, %ds, %dms", this.latestBatchProcessingTimeInDays, remainingHours, remainingMinutes, remainingSeconds, remainingMillis);
    }

    public String getLatestBatchHumanReadableProcessingTime() {
        return this.latestBatchHumanReadableProcessingTime;
    }

    public long getLatestBatchProcessingTimeInDays() {
        return this.latestBatchProcessingTimeInDays;
    }

    public long getLatestBatchProcessingTimeInHours() {
        return this.latestBatchProcessingTimeInHours;
    }

    public long getLatestBatchProcessingTimeInMinutes() {
        return this.latestBatchProcessingTimeInMinutes;
    }

    public long getLatestBatchProcessingTimeInSeconds() {
        return this.latestBatchProcessingTimeInSeconds;
    }

    public long getLatestBatchProcessingTimeInMillis() {
        return this.latestBatchProcessingTimeInMillis;
    }

    public abstract String getReportMessage();

    protected String getDefaultReportMessageForResource(@Nonnull String resourceString) {
        return String.format("Summary: %s %s were processed in total (%s created, %s updated and %s failed to sync).", this.getProcessed(), resourceString, this.getCreated(), this.getUpdated(), this.getFailed());
    }
}

