/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import io.sphere.sdk.types.Custom;
import io.sphere.sdk.types.CustomFields;
import io.sphere.sdk.types.CustomFieldsDraft;
import io.sphere.sdk.types.CustomFieldsDraftBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CustomTypeReferenceResolutionUtils {
    @Nullable
    public static <T extends Custom> CustomFieldsDraft mapToCustomFieldsDraft(@Nonnull T resource, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        CustomFields custom = resource.getCustom();
        return CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(custom, referenceIdToKeyCache);
    }

    @Nullable
    public static CustomFieldsDraft mapToCustomFieldsDraft(@Nullable CustomFields custom, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (custom != null) {
            String typeId = custom.getType().getId();
            if (referenceIdToKeyCache.containsKey(typeId)) {
                return CustomFieldsDraft.ofTypeKeyAndJson((String)referenceIdToKeyCache.get(typeId), (Map)custom.getFieldsJsonMap());
            }
            return CustomFieldsDraftBuilder.of((CustomFields)custom).build();
        }
        return null;
    }

    private CustomTypeReferenceResolutionUtils() {
    }
}

