/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.helpers.CategoryReferencePair;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.utils.VariantReferenceResolutionUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.ResourceIdentifiable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.CategoryOrderHints;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductDraftBuilder;
import io.sphere.sdk.products.ProductDraftDsl;
import io.sphere.sdk.products.ProductProjection;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.ProductVariantDraftDsl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductReferenceResolutionUtils {
    @Nonnull
    public static List<ProductDraft> mapToProductDrafts(@Nonnull List<ProductProjection> products, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return products.stream().filter(Objects::nonNull).map(product -> {
            ProductDraftDsl productDraft = ProductReferenceResolutionUtils.getDraftBuilderFromStagedProduct(product).build();
            CategoryReferencePair categoryReferencePair = ProductReferenceResolutionUtils.mapToCategoryReferencePair(product, referenceIdToKeyCache);
            Set<ResourceIdentifier<Category>> categoryResourceIdentifiers = categoryReferencePair.getCategoryResourceIdentifiers();
            CategoryOrderHints categoryOrderHintsWithKeys = categoryReferencePair.getCategoryOrderHints();
            List allVariants = product.getAllVariants();
            List<ProductVariantDraft> variantDraftsWithKeys = VariantReferenceResolutionUtils.mapToProductVariantDrafts(allVariants, referenceIdToKeyCache);
            ProductVariantDraft masterVariantDraftWithKeys = variantDraftsWithKeys.remove(0);
            return ((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ProductDraft)productDraft).masterVariant(masterVariantDraftWithKeys)).variants(variantDraftsWithKeys).productType(SyncUtils.getResourceIdentifierWithKey(product.getProductType(), referenceIdToKeyCache))).categories(categoryResourceIdentifiers)).categoryOrderHints(categoryOrderHintsWithKeys)).taxCategory(SyncUtils.getResourceIdentifierWithKey(product.getTaxCategory(), referenceIdToKeyCache))).state(SyncUtils.getResourceIdentifierWithKey(product.getState(), referenceIdToKeyCache))).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static ProductDraftBuilder getDraftBuilderFromStagedProduct(@Nonnull ProductProjection product) {
        List allVariants = product.getAllVariants().stream().map(productVariant -> ProductVariantDraftBuilder.of((ProductVariant)productVariant).build()).collect(Collectors.toList());
        ProductVariantDraftDsl masterVariant = ProductVariantDraftBuilder.of((ProductVariant)product.getMasterVariant()).build();
        return (ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ResourceIdentifiable)product.getProductType(), (LocalizedString)product.getName(), (LocalizedString)product.getSlug(), allVariants).masterVariant((ProductVariantDraft)masterVariant)).metaDescription(product.getMetaDescription())).metaKeywords(product.getMetaKeywords())).metaTitle(product.getMetaTitle())).description(product.getDescription())).searchKeywords(product.getSearchKeywords())).taxCategory(product.getTaxCategory()).state(product.getState()).key(product.getKey())).publish(product.isPublished())).categories(new ArrayList(product.getCategories())).categoryOrderHints(product.getCategoryOrderHints());
    }

    @Nonnull
    static CategoryReferencePair mapToCategoryReferencePair(@Nonnull ProductProjection product, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        Set categoryReferences = product.getCategories();
        HashSet<ResourceIdentifier<Category>> categoryResourceIdentifiers = new HashSet<ResourceIdentifier<Category>>();
        CategoryOrderHints categoryOrderHints = product.getCategoryOrderHints();
        HashMap categoryOrderHintsMapWithKeys = new HashMap();
        categoryReferences.forEach(categoryReference -> {
            if (categoryReference != null) {
                String categoryId = categoryReference.getId();
                if (referenceIdToKeyCache.containsKey(categoryId)) {
                    String categoryOrderHintValue;
                    String categoryKey = referenceIdToKeyCache.get(categoryId);
                    if (categoryOrderHints != null && (categoryOrderHintValue = categoryOrderHints.get(categoryId)) != null) {
                        categoryOrderHintsMapWithKeys.put(categoryKey, categoryOrderHintValue);
                    }
                    categoryResourceIdentifiers.add(ResourceIdentifier.ofKey((String)categoryKey));
                } else {
                    categoryResourceIdentifiers.add(ResourceIdentifier.ofId((String)categoryReference.getId()));
                }
            }
        });
        CategoryOrderHints categoryOrderHintsWithKeys = categoryOrderHintsMapWithKeys.isEmpty() ? categoryOrderHints : CategoryOrderHints.of(categoryOrderHintsMapWithKeys);
        return CategoryReferencePair.of(categoryResourceIdentifiers, categoryOrderHintsWithKeys);
    }

    private ProductReferenceResolutionUtils() {
    }
}

