/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class ProductTypeSyncStatistics
extends BaseSyncStatistics {
    private ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>>> missingNestedProductTypes = new ConcurrentHashMap();

    ProductTypeSyncStatistics(@Nonnull ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>>> missingNestedProductTypes) {
        this.missingNestedProductTypes = missingNestedProductTypes;
    }

    public ProductTypeSyncStatistics() {
    }

    @Override
    public String getReportMessage() {
        return String.format("Summary: %s product types were processed in total (%s created, %s updated, %s failed to sync and %s product types with at least one NestedType or a Set of NestedType attribute definition(s) referencing a missing product type).", this.getProcessed(), this.getCreated(), this.getUpdated(), this.getFailed(), this.getNumberOfProductTypesWithMissingNestedProductTypes());
    }

    public int getNumberOfProductTypesWithMissingNestedProductTypes() {
        HashSet productTypesWithMissingReferences = new HashSet();
        this.missingNestedProductTypes.values().stream().map(ConcurrentHashMap::keySet).flatMap(Collection::stream).forEach(productTypesWithMissingReferences::add);
        return productTypesWithMissingReferences.size();
    }

    public Map<String, ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>>> getProductTypeKeysWithMissingParents() {
        return Collections.unmodifiableMap(this.missingNestedProductTypes);
    }

    public void putMissingNestedProductType(@Nonnull String missingNestedProductTypeKey, @Nonnull String referencingProductTypeKey, @Nonnull AttributeDefinitionDraft referencingAttributeDefinitionDraft) {
        ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>> existingReferencingProductTypes = this.missingNestedProductTypes.get(missingNestedProductTypeKey);
        if (existingReferencingProductTypes != null) {
            ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean> existingAttributeDefinitionDrafts = existingReferencingProductTypes.get(referencingProductTypeKey);
            if (existingAttributeDefinitionDrafts != null) {
                existingAttributeDefinitionDrafts.add(referencingAttributeDefinitionDraft);
            } else {
                existingReferencingProductTypes.put(referencingProductTypeKey, this.asSet(referencingAttributeDefinitionDraft));
            }
        } else {
            this.missingNestedProductTypes.put(missingNestedProductTypeKey, this.asMap(referencingProductTypeKey, referencingAttributeDefinitionDraft));
        }
    }

    @Nonnull
    private ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>> asMap(@Nonnull String referencingProductTypeKey, @Nonnull AttributeDefinitionDraft referencingAttributeDefinitionDraft) {
        ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>> newReferencingProductTypes = new ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>>();
        newReferencingProductTypes.put(referencingProductTypeKey, this.asSet(referencingAttributeDefinitionDraft));
        return newReferencingProductTypes;
    }

    @Nonnull
    private ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean> asSet(@Nonnull AttributeDefinitionDraft referencingAttributeDefinitionDraft) {
        ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean> newAttributeDefinitions = ConcurrentHashMap.newKeySet();
        newAttributeDefinitions.add(referencingAttributeDefinitionDraft);
        return newAttributeDefinitions;
    }

    public void removeReferencingProductTypeKey(@Nonnull String referencingProductTypeKey) {
        Iterator<ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>>> referencingProductTypesIterator = this.missingNestedProductTypes.values().iterator();
        while (referencingProductTypesIterator.hasNext()) {
            ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>> referencingProductTypes = referencingProductTypesIterator.next();
            referencingProductTypes.remove(referencingProductTypeKey);
            if (!referencingProductTypes.isEmpty()) continue;
            referencingProductTypesIterator.remove();
        }
    }
}

