/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.helpers.ResourceKeyIdGraphQlRequest;
import com.commercetools.sync.commons.models.GraphQlQueryResources;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import com.commercetools.sync.taxcategories.TaxCategorySyncOptions;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.taxcategories.TaxCategory;
import io.sphere.sdk.taxcategories.TaxCategoryDraft;
import io.sphere.sdk.taxcategories.commands.TaxCategoryCreateCommand;
import io.sphere.sdk.taxcategories.commands.TaxCategoryUpdateCommand;
import io.sphere.sdk.taxcategories.expansion.TaxCategoryExpansionModel;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQuery;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQueryBuilder;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQueryModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TaxCategoryServiceImpl
extends BaseServiceWithKey<TaxCategoryDraft, TaxCategory, TaxCategory, TaxCategorySyncOptions, TaxCategoryQuery, TaxCategoryQueryModel, TaxCategoryExpansionModel<TaxCategory>>
implements TaxCategoryService {
    public TaxCategoryServiceImpl(@Nonnull TaxCategorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> taxCategoryKeys) {
        return this.cacheKeysToIds(taxCategoryKeys, keysNotCached -> new ResourceKeyIdGraphQlRequest((Set<String>)keysNotCached, GraphQlQueryResources.TAX_CATEGORIES));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTaxCategoryId(@Nullable String key) {
        return this.fetchCachedResourceId(key, () -> TaxCategoryQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn(Collections.singleton(key))).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Set<TaxCategory>> fetchMatchingTaxCategoriesByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, keysNotCached -> TaxCategoryQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keysNotCached)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<TaxCategory>> fetchTaxCategory(@Nullable String key) {
        return this.fetchResource(key, () -> TaxCategoryQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<TaxCategory>> createTaxCategory(@Nonnull TaxCategoryDraft taxCategoryDraft) {
        return this.createResource(taxCategoryDraft, TaxCategoryCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<TaxCategory> updateTaxCategory(@Nonnull TaxCategory taxCategory, @Nonnull List<UpdateAction<TaxCategory>> updateActions) {
        return this.updateResource(taxCategory, TaxCategoryUpdateCommand::of, updateActions);
    }
}

