/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories.utils;

import com.neovisionaries.i18n.CountryCode;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.taxcategories.TaxCategory;
import io.sphere.sdk.taxcategories.TaxRate;
import io.sphere.sdk.taxcategories.TaxRateDraft;
import io.sphere.sdk.taxcategories.TaxRateDraftBuilder;
import io.sphere.sdk.taxcategories.commands.updateactions.AddTaxRate;
import io.sphere.sdk.taxcategories.commands.updateactions.RemoveTaxRate;
import io.sphere.sdk.taxcategories.commands.updateactions.ReplaceTaxRate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class TaxRatesUpdateActionUtils {
    private TaxRatesUpdateActionUtils() {
    }

    @Nonnull
    static List<UpdateAction<TaxCategory>> buildTaxRatesUpdateActions(@Nonnull List<TaxRate> oldTaxRates, List<TaxRateDraft> newTaxRatesDrafts) {
        if (newTaxRatesDrafts != null && !newTaxRatesDrafts.isEmpty()) {
            return TaxRatesUpdateActionUtils.buildUpdateActions(oldTaxRates, newTaxRatesDrafts.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return oldTaxRates.stream().map(TaxRate::getId).filter(Objects::nonNull).map(RemoveTaxRate::of).collect(Collectors.toList());
    }

    @Nonnull
    private static List<UpdateAction<TaxCategory>> buildUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRatesDrafts) {
        ArrayList<TaxRateDraft> newTaxRateDraftsCopy = new ArrayList<TaxRateDraft>(newTaxRatesDrafts);
        List<UpdateAction<TaxCategory>> updateActions = TaxRatesUpdateActionUtils.buildRemoveOrReplaceTaxRateUpdateActions(oldTaxRates, newTaxRateDraftsCopy);
        updateActions.addAll(TaxRatesUpdateActionUtils.buildAddTaxRateUpdateActions(oldTaxRates, newTaxRateDraftsCopy));
        return updateActions;
    }

    @Nonnull
    private static List<UpdateAction<TaxCategory>> buildRemoveOrReplaceTaxRateUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRatesDrafts) {
        return oldTaxRates.stream().map(oldTaxRate -> newTaxRatesDrafts.stream().filter(newTaxRateDraft -> Objects.equals(oldTaxRate.getCountry(), newTaxRateDraft.getCountry()) && Objects.equals(oldTaxRate.getState(), newTaxRateDraft.getState())).findFirst().map(matchedTaxRateDraft -> {
            if (!TaxRatesUpdateActionUtils.hasSameFields(oldTaxRate, matchedTaxRateDraft)) {
                newTaxRatesDrafts.remove(matchedTaxRateDraft);
                return Collections.singletonList(ReplaceTaxRate.of((String)oldTaxRate.getId(), (TaxRateDraft)matchedTaxRateDraft));
            }
            return new ArrayList();
        }).orElseGet(() -> Collections.singletonList(RemoveTaxRate.of((String)oldTaxRate.getId())))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static List<UpdateAction<TaxCategory>> buildAddTaxRateUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRateDrafts) {
        Map<String, TaxRate> taxRateDraftMap = oldTaxRates.stream().collect(Collectors.toMap(taxRate -> TaxRatesUpdateActionUtils.getTaxRateDraftMapKey(taxRate.getCountry(), taxRate.getState()), taxRateDraft -> taxRateDraft));
        return newTaxRateDrafts.stream().filter(taxRateDraft -> taxRateDraft.getCountry() != null && !taxRateDraftMap.containsKey(TaxRatesUpdateActionUtils.getTaxRateDraftMapKey(taxRateDraft.getCountry(), taxRateDraft.getState()))).map(AddTaxRate::of).collect(Collectors.toList());
    }

    @Nonnull
    private static String getTaxRateDraftMapKey(CountryCode countryCode, String state) {
        return StringUtils.isEmpty((CharSequence)state) ? countryCode.toString() : String.format("%s_%s", countryCode, state);
    }

    private static boolean hasSameFields(@Nonnull TaxRate oldTaxRate, @Nonnull TaxRateDraft newTaxRate) {
        return TaxRateDraftBuilder.of((TaxRate)oldTaxRate).build().equals(newTaxRate);
    }
}

