/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.helpers;

import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.types.TypeSyncOptions;
import com.commercetools.sync.types.helpers.TypeSyncStatistics;
import io.sphere.sdk.types.TypeDraft;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TypeBatchValidator
extends BaseBatchValidator<TypeDraft, TypeSyncOptions, TypeSyncStatistics> {
    static final String TYPE_DRAFT_KEY_NOT_SET = "TypeDraft with name: %s doesn't have a key. Please make sure all type drafts have keys.";
    static final String TYPE_DRAFT_IS_NULL = "TypeDraft is null.";

    public TypeBatchValidator(@Nonnull TypeSyncOptions syncOptions, @Nonnull TypeSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<TypeDraft>, Set<String>> validateAndCollectReferencedKeys(@Nonnull List<TypeDraft> typeDrafts) {
        Set validDrafts = typeDrafts.stream().filter(this::isValidTypeDraft).collect(Collectors.toSet());
        Set validKeys = validDrafts.stream().map(TypeDraft::getKey).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, validKeys);
    }

    private boolean isValidTypeDraft(@Nullable TypeDraft typeDraft) {
        if (typeDraft == null) {
            this.handleError(TYPE_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)typeDraft.getKey())) {
            this.handleError(String.format(TYPE_DRAFT_KEY_NOT_SET, typeDraft.getName()));
        } else {
            return true;
        }
        return false;
    }
}

