/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryAssetActionFactory;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.AssetsUpdateActionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.commands.updateactions.ChangeName;
import io.sphere.sdk.categories.commands.updateactions.ChangeOrderHint;
import io.sphere.sdk.categories.commands.updateactions.ChangeParent;
import io.sphere.sdk.categories.commands.updateactions.ChangeSlug;
import io.sphere.sdk.categories.commands.updateactions.SetDescription;
import io.sphere.sdk.categories.commands.updateactions.SetExternalId;
import io.sphere.sdk.categories.commands.updateactions.SetMetaDescription;
import io.sphere.sdk.categories.commands.updateactions.SetMetaKeywords;
import io.sphere.sdk.categories.commands.updateactions.SetMetaTitle;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class CategoryUpdateActionUtils {
    private static final String CATEGORY_CHANGE_PARENT_EMPTY_PARENT = "Cannot unset 'parent' field of category with id '%s'.";
    private static final String CATEGORY_CHANGE_ORDER_HINT_EMPTY_ORDERHINT = "Cannot unset 'orderHint' field of category with id '%s'.";

    @Nonnull
    public static Optional<UpdateAction<Category>> buildChangeNameUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getName(), newCategory.getName(), () -> ChangeName.of((LocalizedString)newCategory.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildChangeSlugUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getSlug(), newCategory.getSlug(), () -> ChangeSlug.of((LocalizedString)newCategory.getSlug()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetDescriptionUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getDescription(), newCategory.getDescription(), () -> SetDescription.of((LocalizedString)newCategory.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildChangeParentUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        Reference oldParent = oldCategory.getParent();
        ResourceIdentifier newParent = newCategory.getParent();
        if (newParent == null && oldParent != null) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CATEGORY_CHANGE_PARENT_EMPTY_PARENT, oldCategory.getId())), oldCategory, newCategory);
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldParent, newParent, () -> ChangeParent.of((ResourceIdentifier)ResourceIdentifier.ofId((String)newParent.getId())));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildChangeOrderHintUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        if (newCategory.getOrderHint() == null && oldCategory.getOrderHint() != null) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CATEGORY_CHANGE_ORDER_HINT_EMPTY_ORDERHINT, oldCategory.getId())), oldCategory, newCategory);
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getOrderHint(), newCategory.getOrderHint(), () -> ChangeOrderHint.of((String)newCategory.getOrderHint()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetMetaTitleUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaTitle(), newCategory.getMetaTitle(), () -> SetMetaTitle.of((LocalizedString)newCategory.getMetaTitle()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetMetaKeywordsUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaKeywords(), newCategory.getMetaKeywords(), () -> SetMetaKeywords.of((LocalizedString)newCategory.getMetaKeywords()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetMetaDescriptionUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaDescription(), newCategory.getMetaDescription(), () -> SetMetaDescription.of((LocalizedString)newCategory.getMetaDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<Category>> buildSetExternalIdUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getExternalId(), newCategory.getExternalId(), () -> SetExternalId.of((String)newCategory.getExternalId()));
    }

    @Nonnull
    public static List<UpdateAction<Category>> buildAssetsUpdateActions(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        try {
            return AssetsUpdateActionUtils.buildAssetsUpdateActions(newCategory, oldCategory.getAssets(), newCategory.getAssets(), new CategoryAssetActionFactory(syncOptions), syncOptions);
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the assets of the category with the key '%s'.", oldCategory.getKey()), exception), oldCategory, newCategory, null);
            return Collections.emptyList();
        }
    }

    private CategoryUpdateActionUtils() {
    }
}

