/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.utils.CustomerCustomActionBuilder;
import com.commercetools.sync.customers.utils.CustomerUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.customers.Customer;
import io.sphere.sdk.customers.CustomerDraft;
import java.util.List;
import javax.annotation.Nonnull;

public final class CustomerSyncUtils {
    private static final CustomerCustomActionBuilder customerCustomActionBuilder = CustomerCustomActionBuilder.of();

    @Nonnull
    public static List<UpdateAction<Customer>> buildActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer, @Nonnull CustomerSyncOptions syncOptions) {
        List<UpdateAction<Customer>> updateActions = OptionalUtils.filterEmptyOptionals(CustomerUpdateActionUtils.buildChangeEmailUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetFirstNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetLastNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetMiddleNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetTitleUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetSalutationUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCustomerGroupUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCustomerNumberUpdateAction(oldCustomer, newCustomer, syncOptions), CustomerUpdateActionUtils.buildSetExternalIdUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCompanyNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetDateOfBirthUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetVatIdUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetLocaleUpdateAction(oldCustomer, newCustomer));
        List<UpdateAction<Customer>> addressUpdateActions = CustomerUpdateActionUtils.buildAllAddressUpdateActions(oldCustomer, newCustomer);
        updateActions.addAll(addressUpdateActions);
        List<UpdateAction<Customer>> customerCustomUpdateActions = CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(oldCustomer, newCustomer, customerCustomActionBuilder, syncOptions);
        updateActions.addAll(customerCustomUpdateActions);
        List<UpdateAction<Customer>> buildStoreUpdateActions = CustomerUpdateActionUtils.buildStoreUpdateActions(oldCustomer, newCustomer);
        updateActions.addAll(buildStoreUpdateActions);
        return updateActions;
    }

    private CustomerSyncUtils() {
    }
}

