/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customobjects;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customobjects.CustomObjectSyncOptions;
import com.commercetools.sync.customobjects.helpers.CustomObjectBatchValidator;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.customobjects.helpers.CustomObjectSyncStatistics;
import com.commercetools.sync.customobjects.utils.CustomObjectSyncUtils;
import com.commercetools.sync.services.CustomObjectService;
import com.commercetools.sync.services.impl.CustomObjectServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.CustomObjectDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CustomObjectSync
extends BaseSync<CustomObjectDraft<JsonNode>, CustomObject<JsonNode>, CustomObjectSyncStatistics, CustomObjectSyncOptions> {
    private static final String CTP_CUSTOM_OBJECT_FETCH_FAILED = "Failed to fetch existing custom objects with keys: '%s'.";
    private static final String CTP_CUSTOM_OBJECT_UPDATE_FAILED = "Failed to update custom object with key: '%s'. Reason: %s";
    private static final String CTP_CUSTOM_OBJECT_CREATE_FAILED = "Failed to create custom object with key: '%s'. Reason: %s";
    private final CustomObjectService customObjectService;
    private final CustomObjectBatchValidator batchValidator;

    public CustomObjectSync(@Nonnull CustomObjectSyncOptions syncOptions) {
        this(syncOptions, new CustomObjectServiceImpl(syncOptions));
    }

    CustomObjectSync(@Nonnull CustomObjectSyncOptions syncOptions, @Nonnull CustomObjectService customObjectService) {
        super(new CustomObjectSyncStatistics(), syncOptions);
        this.customObjectService = customObjectService;
        this.batchValidator = new CustomObjectBatchValidator((CustomObjectSyncOptions)this.getSyncOptions(), (CustomObjectSyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<CustomObjectSyncStatistics> process(@Nonnull List<CustomObjectDraft<JsonNode>> customObjectDrafts) {
        List batches = SyncUtils.batchElements(customObjectDrafts, ((CustomObjectSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((CustomObjectSyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<CustomObjectSyncStatistics> processBatch(@Nonnull List<CustomObjectDraft<JsonNode>> batch) {
        ImmutablePair<Set<CustomObjectDraft<JsonNode>>, Set<CustomObjectCompositeIdentifier>> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((CustomObjectSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture((CustomObjectSyncStatistics)this.statistics);
        }
        Set validIdentifiers = (Set)result.getRight();
        return this.customObjectService.fetchMatchingCustomObjects(validIdentifiers).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedCustomObjects = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_CUSTOM_OBJECT_FETCH_FAILED, validIdentifiers);
                this.handleError(errorMessage, exception, null, null, null, validIdentifiers.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedCustomObjects, validDrafts);
        }).thenApply(ignored -> {
            ((CustomObjectSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (CustomObjectSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<CustomObject<JsonNode>> oldCustomObjects, @Nonnull Set<CustomObjectDraft<JsonNode>> newCustomObjectDrafts) {
        Map oldCustomObjectMap = oldCustomObjects.stream().collect(Collectors.toMap(customObject -> CustomObjectCompositeIdentifier.of(customObject.getKey(), customObject.getContainer()).toString(), Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newCustomObjectDrafts.stream().map(newCustomObjectDraft -> {
            CustomObject oldCustomObject = (CustomObject)oldCustomObjectMap.get(CustomObjectCompositeIdentifier.of(newCustomObjectDraft).toString());
            return Optional.ofNullable(oldCustomObject).map(customObject -> this.updateCustomObject((CustomObject<JsonNode>)oldCustomObject, (CustomObjectDraft<JsonNode>)newCustomObjectDraft)).orElseGet(() -> this.applyCallbackAndCreate((CustomObjectDraft<JsonNode>)newCustomObjectDraft));
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Optional<CustomObject<JsonNode>>> applyCallbackAndCreate(@Nonnull CustomObjectDraft<JsonNode> customObjectDraft) {
        return ((CustomObjectSyncOptions)this.syncOptions).applyBeforeCreateCallback(customObjectDraft).map(draft -> this.customObjectService.upsertCustomObject((CustomObjectDraft<JsonNode>)draft).thenApply(customObjectOptional -> {
            if (customObjectOptional.isPresent()) {
                ((CustomObjectSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((CustomObjectSyncStatistics)this.statistics).incrementFailed();
            }
            return customObjectOptional;
        }).exceptionally(sphereException -> {
            String errorMessage = String.format(CTP_CUSTOM_OBJECT_CREATE_FAILED, CustomObjectCompositeIdentifier.of(customObjectDraft).toString(), sphereException.getMessage());
            this.handleError(errorMessage, (Throwable)sphereException, null, customObjectDraft, null, 1);
            return Optional.empty();
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    private CompletionStage<Optional<CustomObject<JsonNode>>> updateCustomObject(@Nonnull CustomObject<JsonNode> oldCustomObject, @Nonnull CustomObjectDraft<JsonNode> newCustomObject) {
        if (!CustomObjectSyncUtils.hasIdenticalValue(oldCustomObject, newCustomObject)) {
            return this.customObjectService.upsertCustomObject(newCustomObject).handle(ImmutablePair::new).thenCompose(updatedResponseEntry -> {
                Optional updateCustomObjectOptional = (Optional)updatedResponseEntry.getKey();
                Throwable sphereException = (Throwable)updatedResponseEntry.getValue();
                if (sphereException != null) {
                    return CustomObjectSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldCustomObject, newCustomObject), () -> {
                        String errorMessage = String.format(CTP_CUSTOM_OBJECT_UPDATE_FAILED, CustomObjectCompositeIdentifier.of(newCustomObject).toString(), sphereException.getMessage());
                        this.handleError(errorMessage, sphereException, oldCustomObject, newCustomObject, null, 1);
                        return CompletableFuture.completedFuture(Optional.empty());
                    });
                }
                ((CustomObjectSyncStatistics)this.statistics).incrementUpdated();
                return CompletableFuture.completedFuture(Optional.of((CustomObject)updateCustomObjectOptional.get()));
            });
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Nonnull
    private CompletionStage<Optional<CustomObject<JsonNode>>> fetchAndUpdate(@Nonnull CustomObject<JsonNode> oldCustomObject, @Nonnull CustomObjectDraft<JsonNode> customObjectDraft) {
        CustomObjectCompositeIdentifier identifier = CustomObjectCompositeIdentifier.of(oldCustomObject);
        return this.customObjectService.fetchCustomObject(identifier).handle(ImmutablePair::new).thenCompose(fetchedResponseEntry -> {
            Optional fetchedCustomObjectOptional = (Optional)fetchedResponseEntry.getKey();
            Throwable exception = (Throwable)fetchedResponseEntry.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_CUSTOM_OBJECT_UPDATE_FAILED, identifier.toString(), "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldCustomObject, customObjectDraft, null, 1);
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return fetchedCustomObjectOptional.map(fetchedCustomObject -> this.updateCustomObject((CustomObject<JsonNode>)fetchedCustomObject, customObjectDraft)).orElseGet(() -> {
                String errorMessage = String.format(CTP_CUSTOM_OBJECT_UPDATE_FAILED, identifier.toString(), "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldCustomObject, customObjectDraft, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

