/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.InventoryEntryDraftBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class InventoryReferenceResolutionUtils {
    @Nonnull
    public static List<InventoryEntryDraft> mapToInventoryEntryDrafts(@Nonnull List<InventoryEntry> inventoryEntries, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return inventoryEntries.stream().map(inventoryEntry -> InventoryReferenceResolutionUtils.mapToInventoryEntryDraft(inventoryEntry, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static InventoryEntryDraft mapToInventoryEntryDraft(@Nonnull InventoryEntry inventoryEntry, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return InventoryEntryDraftBuilder.of((InventoryEntry)inventoryEntry).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(inventoryEntry, referenceIdToKeyCache)).supplyChannel(SyncUtils.getResourceIdentifierWithKey(inventoryEntry.getSupplyChannel(), referenceIdToKeyCache)).build();
    }

    private InventoryReferenceResolutionUtils() {
    }
}

