/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.helpers.AttributeDefinitionReferenceResolver;
import com.commercetools.sync.services.ProductTypeService;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.ProductTypeDraftBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProductTypeReferenceResolver
extends BaseReferenceResolver<ProductTypeDraft, ProductTypeSyncOptions> {
    private final AttributeDefinitionReferenceResolver attributeDefinitionReferenceResolver;

    public ProductTypeReferenceResolver(@Nonnull ProductTypeSyncOptions productTypeSyncOptions, @Nonnull ProductTypeService productTypeService) {
        super(productTypeSyncOptions);
        this.attributeDefinitionReferenceResolver = new AttributeDefinitionReferenceResolver(productTypeSyncOptions, productTypeService);
    }

    @Override
    @Nonnull
    public CompletionStage<ProductTypeDraft> resolveReferences(@Nonnull ProductTypeDraft productTypeDraft) {
        return this.resolveAttributeDefinitionsReferences(ProductTypeDraftBuilder.of((ProductTypeDraft)productTypeDraft)).thenApply(ProductTypeDraftBuilder::build);
    }

    @Nonnull
    CompletionStage<ProductTypeDraftBuilder> resolveAttributeDefinitionsReferences(@Nonnull ProductTypeDraftBuilder productTypeDraftBuilder) {
        List attributeDefinitionDrafts = productTypeDraftBuilder.getAttributes();
        if (attributeDefinitionDrafts == null) {
            return CompletableFuture.completedFuture(productTypeDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(attributeDefinitionDrafts, this.attributeDefinitionReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ProductTypeDraftBuilder)productTypeDraftBuilder).attributes(arg_0));
    }
}

