/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.utils.LineItemCustomActionBuilder;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.shoppinglists.LineItem;
import io.sphere.sdk.shoppinglists.LineItemDraft;
import io.sphere.sdk.shoppinglists.ShoppingList;
import io.sphere.sdk.shoppinglists.ShoppingListDraft;
import io.sphere.sdk.shoppinglists.commands.updateactions.AddLineItem;
import io.sphere.sdk.shoppinglists.commands.updateactions.ChangeLineItemQuantity;
import io.sphere.sdk.shoppinglists.commands.updateactions.RemoveLineItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class LineItemUpdateActionUtils {
    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildLineItemsUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull ShoppingListSyncOptions syncOptions) {
        boolean hasNewLineItems;
        boolean hasOldLineItems = oldShoppingList.getLineItems() != null && !oldShoppingList.getLineItems().isEmpty();
        boolean bl = hasNewLineItems = newShoppingList.getLineItems() != null && !newShoppingList.getLineItems().isEmpty() && newShoppingList.getLineItems().stream().anyMatch(Objects::nonNull);
        if (hasOldLineItems && !hasNewLineItems) {
            return oldShoppingList.getLineItems().stream().map(RemoveLineItem::of).collect(Collectors.toList());
        }
        if (!hasOldLineItems) {
            if (!hasNewLineItems) {
                return Collections.emptyList();
            }
            return newShoppingList.getLineItems().stream().filter(Objects::nonNull).filter(LineItemUpdateActionUtils::hasQuantity).map(AddLineItem::of).collect(Collectors.toList());
        }
        List oldLineItems = oldShoppingList.getLineItems();
        List<LineItemDraft> newlineItems = newShoppingList.getLineItems().stream().filter(Objects::nonNull).collect(Collectors.toList());
        return LineItemUpdateActionUtils.buildUpdateActions(oldShoppingList, newShoppingList, oldLineItems, newlineItems, syncOptions);
    }

    private static boolean hasQuantity(@Nonnull LineItemDraft lineItemDraft) {
        return lineItemDraft.getQuantity() != null && lineItemDraft.getQuantity() > 0L;
    }

    @Nonnull
    private static List<UpdateAction<ShoppingList>> buildUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull List<LineItem> oldLineItems, @Nonnull List<LineItemDraft> newlineItems, @Nonnull ShoppingListSyncOptions syncOptions) {
        int i;
        int minSize;
        ArrayList updateActions = new ArrayList();
        int indexOfFirstDifference = minSize = Math.min(oldLineItems.size(), newlineItems.size());
        for (i = 0; i < minSize; ++i) {
            LineItem oldLineItem = oldLineItems.get(i);
            LineItemDraft newLineItem = newlineItems.get(i);
            if (oldLineItem.getVariant() == null || StringUtils.isBlank((CharSequence)oldLineItem.getVariant().getSku())) {
                syncOptions.applyErrorCallback(new SyncException(String.format("LineItem at position '%d' of the ShoppingList with key '%s' has no SKU set. Please make sure all line items have SKUs.", i, oldShoppingList.getKey())), oldShoppingList, newShoppingList, updateActions);
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)newLineItem.getSku())) {
                syncOptions.applyErrorCallback(new SyncException(String.format("LineItemDraft at position '%d' of the ShoppingListDraft with key '%s' has no SKU set. Please make sure all line item drafts have SKUs.", i, newShoppingList.getKey())), oldShoppingList, newShoppingList, updateActions);
                return Collections.emptyList();
            }
            if (!oldLineItem.getVariant().getSku().equals(newLineItem.getSku())) {
                indexOfFirstDifference = i;
                break;
            }
            updateActions.addAll(LineItemUpdateActionUtils.buildLineItemUpdateActions(oldShoppingList, newShoppingList, oldLineItem, newLineItem, syncOptions));
        }
        for (i = indexOfFirstDifference; i < oldLineItems.size(); ++i) {
            updateActions.add(RemoveLineItem.of((String)oldLineItems.get(i).getId()));
        }
        for (i = indexOfFirstDifference; i < newlineItems.size(); ++i) {
            if (!LineItemUpdateActionUtils.hasQuantity(newlineItems.get(i))) continue;
            updateActions.add((UpdateAction<ShoppingList>)AddLineItem.of((LineItemDraft)newlineItems.get(i)));
        }
        return updateActions;
    }

    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildLineItemUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull LineItem oldLineItem, @Nonnull LineItemDraft newLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        List<UpdateAction<ShoppingList>> updateActions = OptionalUtils.filterEmptyOptionals(LineItemUpdateActionUtils.buildChangeLineItemQuantityUpdateAction(oldLineItem, newLineItem));
        updateActions.addAll(LineItemUpdateActionUtils.buildLineItemCustomUpdateActions(oldShoppingList, newShoppingList, oldLineItem, newLineItem, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<UpdateAction<ShoppingList>> buildChangeLineItemQuantityUpdateAction(@Nonnull LineItem oldLineItem, @Nonnull LineItemDraft newLineItem) {
        Long newLineItemQuantity = newLineItem.getQuantity() == null ? NumberUtils.LONG_ONE : newLineItem.getQuantity();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldLineItem.getQuantity(), newLineItemQuantity, () -> ChangeLineItemQuantity.of((String)oldLineItem.getId(), (Long)newLineItemQuantity));
    }

    @Nonnull
    public static List<UpdateAction<ShoppingList>> buildLineItemCustomUpdateActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull LineItem oldLineItem, @Nonnull LineItemDraft newLineItem, @Nonnull ShoppingListSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(newShoppingList, () -> ((LineItem)oldLineItem).getCustom(), () -> ((LineItemDraft)newLineItem).getCustom(), new LineItemCustomActionBuilder(), null, t -> oldLineItem.getId(), lineItem -> LineItem.resourceTypeId(), t -> oldLineItem.getId(), syncOptions);
    }

    private LineItemUpdateActionUtils() {
    }
}

