/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import io.sphere.sdk.states.StateRole;
import io.sphere.sdk.states.StateType;
import io.sphere.sdk.states.commands.updateactions.AddRoles;
import io.sphere.sdk.states.commands.updateactions.ChangeInitial;
import io.sphere.sdk.states.commands.updateactions.ChangeType;
import io.sphere.sdk.states.commands.updateactions.RemoveRoles;
import io.sphere.sdk.states.commands.updateactions.SetDescription;
import io.sphere.sdk.states.commands.updateactions.SetName;
import io.sphere.sdk.states.commands.updateactions.SetTransitions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;

public final class StateUpdateActionUtils {
    private StateUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<UpdateAction<State>> buildChangeTypeAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getType(), newState.getType(), () -> ChangeType.of((StateType)newState.getType()));
    }

    @Nonnull
    public static Optional<UpdateAction<State>> buildSetNameAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getName(), newState.getName(), () -> SetName.of((LocalizedString)newState.getName()));
    }

    @Nonnull
    public static Optional<UpdateAction<State>> buildSetDescriptionAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldState.getDescription(), newState.getDescription(), () -> SetDescription.of((LocalizedString)newState.getDescription()));
    }

    @Nonnull
    public static Optional<UpdateAction<State>> buildChangeInitialAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        boolean isNewStateInitial = BooleanUtils.toBoolean((Boolean)newState.isInitial());
        boolean isOldStateInitial = BooleanUtils.toBoolean((Boolean)oldState.isInitial());
        return CommonTypeUpdateActionUtils.buildUpdateAction(isOldStateInitial, isNewStateInitial, () -> ChangeInitial.of((boolean)isNewStateInitial));
    }

    @Nonnull
    public static List<UpdateAction<State>> buildRolesUpdateActions(@Nonnull State oldState, @Nonnull StateDraft newState) {
        Set<StateRole> add;
        boolean emptyOld;
        boolean emptyNew = newState.getRoles() == null || newState.getRoles().isEmpty();
        boolean bl = emptyOld = oldState.getRoles() == null || oldState.getRoles().isEmpty();
        if (emptyNew && emptyOld) {
            return Collections.emptyList();
        }
        HashSet<StateRole> newRoles = emptyNew ? new HashSet() : newState.getRoles();
        HashSet<StateRole> oldRoles = emptyOld ? new HashSet() : oldState.getRoles();
        ArrayList<UpdateAction<State>> actions = new ArrayList<UpdateAction<State>>();
        Set<StateRole> remove = StateUpdateActionUtils.diffRoles(oldRoles, newRoles);
        if (!remove.isEmpty()) {
            actions.add((UpdateAction<State>)RemoveRoles.of(remove));
        }
        if (!(add = StateUpdateActionUtils.diffRoles(newRoles, oldRoles)).isEmpty()) {
            actions.add((UpdateAction<State>)AddRoles.of(add));
        }
        return actions;
    }

    @Nonnull
    public static Optional<UpdateAction<State>> buildSetTransitionsAction(@Nonnull State oldState, @Nonnull StateDraft newState) {
        boolean emptyOld;
        boolean emptyNew = newState.getTransitions() == null || newState.getTransitions().isEmpty() || newState.getTransitions().stream().noneMatch(Objects::nonNull);
        boolean bl = emptyOld = oldState.getTransitions() == null || oldState.getTransitions().isEmpty() || oldState.getTransitions().stream().noneMatch(Objects::nonNull);
        if (emptyNew && emptyOld) {
            return Optional.empty();
        }
        if (emptyNew) {
            return Optional.of(SetTransitions.of(Collections.emptySet()));
        }
        Set newTransitions = newState.getTransitions().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Set oldTransitions = oldState.getTransitions().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTransitions, newTransitions, () -> {
            Set transitions = newTransitions.stream().map(transition -> State.referenceOfId((String)transition.getId())).collect(Collectors.toSet());
            return SetTransitions.of(transitions);
        });
    }

    private static Set<StateRole> diffRoles(Set<StateRole> src, Set<StateRole> dst) {
        return src.stream().map(role -> {
            if (!dst.contains(role)) {
                return role;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

