/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model;

import io.vrap.rmf.nodes.antlr.NodeToken;
import io.vrap.rmf.nodes.antlr.NodeTokenProvider;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RamlDiagnostic
implements Resource.Diagnostic {
    private final String message;
    private final String location;
    private final int line;
    private final int column;

    private RamlDiagnostic(String message, String location, int line, int column) {
        this.message = message;
        this.location = location == null ? "<unkown-location>" : location;
        this.line = line;
        this.column = column;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.line >= 0 ? this.line + 1 : this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return String.format("%s (%s,%d,%d)", this.message, this.location, this.getLine(), this.column);
    }

    public static RamlDiagnostic of(String message, String location, int line, int column) {
        return new RamlDiagnostic(message, location, line, column);
    }

    public static RamlDiagnostic of(Diagnostic diagnostic) {
        EObject eObject;
        NodeTokenProvider nodeTokenProvider;
        int line = -1;
        int column = -1;
        String source = diagnostic.getSource();
        if (diagnostic.getData().size() > 0 && diagnostic.getData().get(0) instanceof EObject && (nodeTokenProvider = (NodeTokenProvider)EcoreUtil.getExistingAdapter((Notifier)(eObject = (EObject)diagnostic.getData().get(0)), NodeTokenProvider.class)) != null) {
            NodeToken nodeToken = nodeTokenProvider.getStart();
            line = nodeToken.getLine();
            column = nodeToken.getCharPositionInLine();
            source = nodeToken.getLocation();
        }
        return RamlDiagnostic.of(diagnostic.getMessage(), source, line, column);
    }
}

