/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model;

import com.google.common.collect.Lists;
import io.vrap.rmf.nodes.Node;
import io.vrap.rmf.nodes.NodeCopier;
import io.vrap.rmf.nodes.NodeMerger;
import io.vrap.rmf.nodes.NodeModelBuilder;
import io.vrap.rmf.nodes.ObjectNode;
import io.vrap.rmf.nodes.PropertyNode;
import io.vrap.rmf.nodes.StringNode;
import io.vrap.rmf.nodes.antlr.NodeToken;
import io.vrap.rmf.nodes.antlr.NodeTokenProvider;
import io.vrap.rmf.nodes.util.NodesSwitch;
import io.vrap.rmf.raml.model.RamlModelResult;
import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.modules.ApiBase;
import io.vrap.rmf.raml.model.modules.ApiExtension;
import io.vrap.rmf.raml.model.modules.util.ModulesSwitch;
import io.vrap.rmf.raml.model.resources.Method;
import io.vrap.rmf.raml.model.resources.Parameter;
import io.vrap.rmf.raml.model.resources.ParameterizedApplication;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.resources.ResourceType;
import io.vrap.rmf.raml.model.resources.ResourceTypeApplication;
import io.vrap.rmf.raml.model.resources.Trait;
import io.vrap.rmf.raml.model.resources.TraitApplication;
import io.vrap.rmf.raml.model.resources.util.ResourcesSwitch;
import io.vrap.rmf.raml.model.responses.Body;
import io.vrap.rmf.raml.model.responses.util.ResponsesSwitch;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.Property;
import io.vrap.rmf.raml.model.types.StringInstance;
import io.vrap.rmf.raml.model.types.util.TypesSwitch;
import io.vrap.rmf.raml.model.util.UriFragmentBuilder;
import io.vrap.rmf.raml.model.values.StringTemplate;
import io.vrap.rmf.raml.persistence.RamlResource;
import io.vrap.rmf.raml.persistence.RamlResourceSet;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.antlr.RamlNodeTokenSource;
import io.vrap.rmf.raml.persistence.constructor.ApiConstructor;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import io.vrap.rmf.raml.validation.RamlValidationSetup;
import io.vrap.rmf.raml.validation.RamlValidator;
import io.vrap.rmf.raml.validation.ResolvedRamlValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RamlModelBuilder {
    private final Diagnostician customDiagnostician;
    private final Diagnostician resolvedCustomDiagnostician;

    public RamlModelBuilder() {
        this.customDiagnostician = null;
        this.resolvedCustomDiagnostician = null;
    }

    public RamlModelBuilder(List<RamlValidator> customValidators) {
        this.customDiagnostician = RamlValidationSetup.setupCustom(customValidators.stream().filter(ramlValidator -> !(ramlValidator instanceof ResolvedRamlValidator)).collect(Collectors.toList()));
        this.resolvedCustomDiagnostician = RamlValidationSetup.setupCustomOnly(customValidators.stream().filter(ramlValidator -> ramlValidator instanceof ResolvedRamlValidator).collect(Collectors.toList()));
    }

    public RamlModelResult<Api> buildApi(URI uri) {
        return this.build(uri);
    }

    public <T extends EObject> RamlModelResult<T> build(URI uri) {
        EObject rootObject;
        org.eclipse.emf.ecore.resource.Resource resource = this.load(uri);
        EObject eObject = rootObject = resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0);
        if (resource.getErrors().isEmpty()) {
            List<Resource.Diagnostic> errors;
            RamlResourceSet resourceSet = (RamlResourceSet)rootObject.eResource().getResourceSet();
            ArrayList allContents = Lists.newArrayList((Iterator)EcoreUtil.getAllContents((ResourceSet)resourceSet, (boolean)true));
            SuperTypeFixer superTypeFixer = new SuperTypeFixer();
            allContents.stream().filter(EObject.class::isInstance).map(EObject.class::cast).forEach(e -> {
                Boolean cfr_ignored_0 = (Boolean)superTypeFixer.doSwitch((EObject)e);
            });
            List<Resource.Diagnostic> list = errors = this.customDiagnostician == null ? resourceSet.validate() : resourceSet.validate(this.customDiagnostician);
            if (errors.isEmpty()) {
                EObject resolved;
                EObject eObject2 = resolved = rootObject instanceof ApiBase ? this.resolveToApi(rootObject) : rootObject;
                if (this.resolvedCustomDiagnostician != null) {
                    errors.addAll((Collection<Resource.Diagnostic>)((RamlResource)resolved.eResource()).validate(this.resolvedCustomDiagnostician));
                }
                return RamlModelResult.of(errors, resolved);
            }
            return RamlModelResult.of(errors, rootObject);
        }
        return RamlModelResult.of((List<Resource.Diagnostic>)resource.getErrors(), rootObject);
    }

    private org.eclipse.emf.ecore.resource.Resource load(URI uri) {
        RamlResourceSet resourceSet = new RamlResourceSet();
        org.eclipse.emf.ecore.resource.Resource resource = resourceSet.getResource(uri, true);
        return resource;
    }

    private Api resolveToApi(EObject rootObject) {
        ApiResolver apiResolver = new ApiResolver();
        Api resolvedApi = rootObject instanceof ApiExtension ? apiResolver.caseApiExtension((ApiExtension)rootObject) : apiResolver.caseApi((Api)rootObject);
        return resolvedApi;
    }

    private static class BodyContentTypeResolver
    extends ResponsesSwitch<EObject> {
        private final List<String> defaultMediaTypes;

        public BodyContentTypeResolver(List<String> defaultMediaTypes) {
            this.defaultMediaTypes = defaultMediaTypes;
        }

        @Override
        public EObject caseBody(Body body) {
            if (body.getContentType() == null && this.defaultMediaTypes.size() >= 1) {
                String firstMediaType = this.defaultMediaTypes.get(0);
                body.setContentType(firstMediaType);
                for (int i = 1; i < this.defaultMediaTypes.size(); ++i) {
                    Body copy = (Body)EcoreUtil.copy((EObject)body);
                    copy.setContentType(this.defaultMediaTypes.get(i));
                    body.eContainer().eContents().add((Object)copy);
                }
            }
            return body;
        }
    }

    private static class StringTemplateResolver
    extends NodesSwitch<EObject> {
        private final Map<String, String> parameters;

        public StringTemplateResolver(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public EObject caseStringNode(StringNode stringNode) {
            StringTemplate stringTemplate = StringTemplate.of((String)stringNode.getValue());
            if (stringTemplate != null && stringTemplate.getParameters().size() > 0) {
                String render = stringTemplate.render(this.parameters);
                stringNode.setValue((Object)render);
                NodeTokenProvider existingAdapter = (NodeTokenProvider)EcoreUtil.getExistingAdapter((Notifier)stringNode, NodeTokenProvider.class);
                NodeToken start = existingAdapter.getStart();
                NodeToken nodeToken = start.withType(start.getType(), render);
                stringNode.eAdapters().remove((Object)existingAdapter);
                stringNode.eAdapters().add((Object)new NodeModelBuilder.NodeParserAdapter(nodeToken, nodeToken));
            }
            return stringNode;
        }

        public EObject resolve(EObject eObject) {
            TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)eObject, (boolean)false);
            allProperContents.forEachRemaining(arg_0 -> ((StringTemplateResolver)this).doSwitch(arg_0));
            return eObject;
        }
    }

    private static class ResourceMerger {
        private ResourceMerger() {
        }

        public Resource resolve(Resource resource) {
            ResourceNodeMerge resourceNodeMerge = new ResourceNodeMerge(resource);
            PropertyNode resourceNode = (PropertyNode)resourceNodeMerge.doSwitch(resource);
            URI uri = resource.eResource() == null ? null : resource.eResource().getURI();
            RamlNodeTokenSource lexer = new RamlNodeTokenSource(uri, (Node)resourceNode);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            RAMLParser parser = new RAMLParser((TokenStream)tokenStream);
            RAMLParser.ResourceFacetContext resourceFacetContext = parser.resourceFacet();
            ApiConstructor apiConstructor = new ApiConstructor();
            Resource mergedResource = (Resource)apiConstructor.withinScope(Scope.of(resource.eResource()).with(resource.eContainer()), scope -> (Resource)apiConstructor.visitResourceFacet(resourceFacetContext));
            mergedResource.getResources().clear();
            mergedResource.getResources().addAll((Collection)resource.getResources());
            EcoreUtil.remove((EObject)resource);
            return mergedResource;
        }
    }

    private static class ResourceNodeMerge
    extends ResourcesSwitch<PropertyNode> {
        private final NodeMerger nodeMerger = new NodeMerger();
        private final NodeMerger resourceTypeNodeMerger = new NodeMerger();
        private final Resource resource;

        public ResourceNodeMerge(Resource resource) {
            this.resource = resource;
        }

        @Override
        public PropertyNode caseResource(Resource resource) {
            ObjectNode resourceValueNode;
            PropertyNode resourcePropertyNode = (PropertyNode)NodeCopier.copy((Node)this.getPropertyContainer(resource));
            if (resourcePropertyNode.getValue() instanceof ObjectNode) {
                resourceValueNode = (ObjectNode)resourcePropertyNode.getValue();
                for (Method method : resource.getMethods()) {
                    PropertyNode methodNode = (PropertyNode)this.doSwitch(method);
                    this.replacePropertyNode(method, methodNode, resourceValueNode);
                }
            }
            if (resource.getType() != null) {
                resourceValueNode = resourcePropertyNode.getValue();
                PropertyNode resourceTypeNode = (PropertyNode)this.doSwitch(resource.getType());
                Node resourceTypeValueNode = resourceTypeNode.getValue();
                resourceValueNode = this.nodeMerger.merge(resourceTypeValueNode, (Node)resourceValueNode, true);
                resourcePropertyNode.setValue((Node)resourceValueNode);
            }
            return resourcePropertyNode;
        }

        @Override
        public PropertyNode caseResourceTypeApplication(ResourceTypeApplication resourceTypeApplication) {
            PropertyNode resourceTypeNode = (PropertyNode)this.doSwitch(resourceTypeApplication.getType());
            StringTemplateResolver stringTemplateResolver = this.getStringTemplateResolver(resourceTypeApplication);
            TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)resourceTypeNode, (boolean)false);
            allProperContents.forEachRemaining(stringTemplateResolver::resolve);
            return resourceTypeNode;
        }

        @Override
        public PropertyNode caseResourceType(ResourceType resourceType) {
            PropertyNode resourceTypeNode = (PropertyNode)NodeCopier.copy((Node)this.getPropertyContainer(resourceType));
            ObjectNode resourceTypeValueNode = (ObjectNode)resourceTypeNode.getValue();
            for (Method method : resourceType.getMethods()) {
                PropertyNode methodNode = (PropertyNode)this.doSwitch(method);
                Node methodValueNode = methodNode.getValue();
                for (TraitApplication traitApplication : resourceType.getIs()) {
                    PropertyNode traitApplicationNode = (PropertyNode)this.doSwitch(traitApplication);
                    Node traitApplicationValueNode = traitApplicationNode.getValue();
                    if (traitApplicationValueNode == null) continue;
                    methodValueNode = this.resourceTypeNodeMerger.merge(traitApplicationValueNode, methodValueNode);
                    StringTemplateResolver stringTemplateResolver = this.getStringTemplateResolver(traitApplication, method);
                    TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)methodValueNode, (boolean)false);
                    allProperContents.forEachRemaining(stringTemplateResolver::resolve);
                }
                methodNode.setValue(methodValueNode);
                this.replacePropertyNode(method, methodNode, resourceTypeValueNode);
            }
            if (resourceType.getType() != null) {
                PropertyNode typeNode = (PropertyNode)this.doSwitch(resourceType.getType());
                Node typeValueNode = typeNode.getValue();
                Node mergedTypeValueNode = this.resourceTypeNodeMerger.merge(typeValueNode, (Node)resourceTypeValueNode);
                resourceTypeNode.setValue(mergedTypeValueNode);
            }
            this.removeUsagePropertyNode(resourceTypeNode.getValue());
            return resourceTypeNode;
        }

        private void replacePropertyNode(EObject eObject, PropertyNode replacementNode, ObjectNode newContainer) {
            PropertyNode methodPropertyContainer = this.getPropertyContainer(eObject);
            int index = methodPropertyContainer.eContainer().eContents().indexOf((Object)methodPropertyContainer);
            newContainer.getProperties().set(index, (Object)replacementNode);
        }

        @Override
        public PropertyNode caseMethod(Method method) {
            PropertyNode methodNode = (PropertyNode)NodeCopier.copy((Node)this.getPropertyContainer(method));
            Node methodValueNode = methodNode.getValue();
            for (TraitApplication traitApplication : method.getIs()) {
                PropertyNode traitApplicationNode = (PropertyNode)this.doSwitch(traitApplication);
                Node traitApplicationValueNode = traitApplicationNode.getValue();
                methodValueNode = this.nodeMerger.merge(traitApplicationValueNode, methodValueNode);
                StringTemplateResolver stringTemplateResolver = this.getStringTemplateResolver(traitApplication, method);
                TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)methodValueNode, (boolean)false);
                allProperContents.forEachRemaining(stringTemplateResolver::resolve);
            }
            methodNode.setValue(methodValueNode);
            return methodNode;
        }

        @Override
        public PropertyNode caseTraitApplication(TraitApplication traitApplication) {
            return (PropertyNode)this.doSwitch(traitApplication.getTrait());
        }

        @Override
        public PropertyNode caseTrait(Trait trait) {
            PropertyNode traitNode = (PropertyNode)NodeCopier.copy((Node)this.getPropertyContainer(trait));
            Node traitValueNode = traitNode.getValue();
            for (TraitApplication traitApplication : trait.getIs()) {
                Node traitApplicationNode = (Node)this.doSwitch(traitApplication);
                traitValueNode = this.nodeMerger.merge(traitApplicationNode, traitValueNode);
                StringTemplateResolver stringTemplateResolver = this.getStringTemplateResolver(traitApplication);
                TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)traitValueNode, (boolean)false);
                allProperContents.forEachRemaining(stringTemplateResolver::resolve);
            }
            traitNode.setValue(traitValueNode);
            this.removeUsagePropertyNode(traitValueNode);
            return traitNode;
        }

        private void removeUsagePropertyNode(Node node) {
            ObjectNode objectNode;
            PropertyNode usagePropertyNode;
            if (node instanceof ObjectNode && (usagePropertyNode = (objectNode = (ObjectNode)node).getProperty((Object)"usage")) != null) {
                objectNode.getProperties().remove((Object)usagePropertyNode);
            }
        }

        private StringTemplateResolver getStringTemplateResolver(ParameterizedApplication application, Method method) {
            Map<String, String> allParameters = application.getParameters().stream().filter(p -> p.getValue() instanceof StringInstance).collect(Collectors.toMap(Parameter::getName, p -> ((StringInstance)p.getValue()).getValue()));
            allParameters.put("resourcePath", this.resource.getResourcePath());
            allParameters.put("resourcePathName", this.resource.getResourcePathName());
            allParameters.put("methodName", method.getMethodName());
            return new StringTemplateResolver(allParameters);
        }

        private StringTemplateResolver getStringTemplateResolver(ParameterizedApplication application) {
            Map<String, String> allParameters = application.getParameters().stream().filter(p -> p.getValue() instanceof StringInstance).collect(Collectors.toMap(Parameter::getName, p -> ((StringInstance)p.getValue()).getValue()));
            allParameters.put("resourcePath", this.resource.getResourcePath());
            allParameters.put("resourcePathName", this.resource.getResourcePathName());
            return new StringTemplateResolver(allParameters);
        }

        private PropertyNode getPropertyContainer(EObject eObject) {
            NodeTokenProvider nodeTokenProvider = (NodeTokenProvider)EcoreUtil.getExistingAdapter((Notifier)eObject, NodeTokenProvider.class);
            return nodeTokenProvider.getPropertyContainer();
        }
    }

    private static class ResourceResolver
    extends ResourcesSwitch<Resource> {
        private final ResourceMerger resourceMerger = new ResourceMerger();

        private ResourceResolver() {
        }

        @Override
        public Resource caseResource(Resource resource) {
            ArrayList resources = Lists.newArrayList((Iterable)resource.getResources());
            Resource resolvedResource = this.resourceMerger.resolve(resource);
            for (Resource child : resources) {
                Resource childResource = (Resource)this.doSwitch(child);
                resolvedResource.getResources().add((Object)childResource);
            }
            return resolvedResource;
        }
    }

    private static class ApiResolver
    extends ModulesSwitch<Api> {
        private final UriFragmentBuilder uriFragmentBuilder = new UriFragmentBuilder();

        private ApiResolver() {
        }

        @Override
        public Api caseApi(Api api) {
            org.eclipse.emf.ecore.resource.Resource resource = api.eResource();
            ResourceSet resourceSet = resource.getResourceSet();
            Api resolvedApi = ApiResolver.copy(api);
            URI resolvedApiUri = resource.getURI().appendQuery("resolved=true");
            org.eclipse.emf.ecore.resource.Resource resolvedResource = resourceSet.createResource(resolvedApiUri);
            resolvedResource.getContents().add((Object)resolvedApi);
            resolvedResource.getErrors().addAll((Collection)resource.getErrors());
            ResourceResolver resourceResolver = new ResourceResolver();
            BodyContentTypeResolver bodyContentTypeResolver = new BodyContentTypeResolver((List<String>)api.getMediaType());
            new ArrayList<Resource>((Collection<Resource>)resolvedApi.getResources()).forEach(arg_0 -> ((ResourceResolver)resourceResolver).doSwitch(arg_0));
            resolvedApi.eAllContents().forEachRemaining(arg_0 -> ((BodyContentTypeResolver)bodyContentTypeResolver).doSwitch(arg_0));
            return resolvedApi;
        }

        @Override
        public Api caseApiExtension(ApiExtension apiExtension) {
            ApiBase extend = apiExtension.getExtends();
            Api resolvedApi = extend instanceof ApiExtension ? this.caseApiExtension((ApiExtension)((Object)extend)) : this.caseApi((Api)extend);
            this.merge(apiExtension, resolvedApi);
            return resolvedApi;
        }

        private void merge(ApiExtension apiExtension, Api api) {
            TreeIterator allProperContents = EcoreUtil.getAllProperContents((EObject)api, (boolean)false);
            HashMap<String, EObject> idToEObject = new HashMap<String, EObject>();
            while (allProperContents.hasNext()) {
                EObject eObject = (EObject)allProperContents.next();
                String uriFragment = this.uriFragmentBuilder.getURIFragment(eObject);
                idToEObject.put(uriFragment, eObject);
            }
            this.merge(apiExtension, api, idToEObject);
        }

        private void merge(EObject extension, EObject extendsEObject, Map<String, EObject> idToEObject) {
            this.mergeAttributes(extension, extendsEObject);
            this.mergeCrossReferences(extension, extendsEObject, idToEObject);
            for (EObject extensionChild : extension.eContents()) {
                String uriFragment = this.uriFragmentBuilder.getURIFragment(extensionChild);
                if (idToEObject.containsKey(uriFragment)) {
                    EObject extendsChild = idToEObject.get(uriFragment);
                    this.merge(extensionChild, extendsChild, idToEObject);
                    continue;
                }
                EObject copy = ApiResolver.copy(extensionChild);
                EReference containmentFeature = extensionChild.eContainmentFeature();
                if (containmentFeature.isMany()) {
                    List containment = (List)extendsEObject.eGet((EStructuralFeature)containmentFeature);
                    containment.add(copy);
                    continue;
                }
                extendsEObject.eSet((EStructuralFeature)containmentFeature, (Object)copy);
            }
        }

        private void mergeAttributes(EObject extension, EObject extendsEObject) {
            ArrayList commonAttributes = new ArrayList();
            commonAttributes.addAll(extension.eClass().getEAllAttributes());
            commonAttributes.retainAll((Collection<?>)extendsEObject.eClass().getEAllAttributes());
            List nonDerivedAttributes = commonAttributes.stream().filter(a -> !a.isDerived()).collect(Collectors.toList());
            for (EAttribute attribute : nonDerivedAttributes) {
                if (!extension.eIsSet((EStructuralFeature)attribute)) continue;
                Object attributeValue = extension.eGet((EStructuralFeature)attribute);
                if (attribute.isMany()) {
                    List values = (List)extendsEObject.eGet((EStructuralFeature)attribute);
                    List mergeAttributeValues = (List)attributeValue;
                    for (Object mergeAttributeValue : mergeAttributeValues) {
                        if (values.contains(mergeAttributeValue)) continue;
                        values.add(mergeAttributeValue);
                    }
                    continue;
                }
                extendsEObject.eSet((EStructuralFeature)attribute, attributeValue);
            }
        }

        private void mergeCrossReferences(EObject extension, EObject extendsEObject, Map<String, EObject> idToEObject) {
            List allNonContainmentReferences = extendsEObject.eClass().getEAllReferences().stream().filter(reference -> !reference.isContainment() && !reference.isDerived()).collect(Collectors.toList());
            for (EReference reference2 : allNonContainmentReferences) {
                if (!extension.eIsSet((EStructuralFeature)reference2) || reference2.isMany()) continue;
                EObject referee = (EObject)extension.eGet((EStructuralFeature)reference2);
                if (referee.eResource().getURI().equals(BuiltinType.RESOURCE_URI)) {
                    extendsEObject.eSet((EStructuralFeature)reference2, (Object)referee);
                    continue;
                }
                String uriFragment = this.uriFragmentBuilder.getURIFragment(referee);
                EObject extendsReferee = idToEObject.get(uriFragment);
                extendsEObject.eSet((EStructuralFeature)reference2, (Object)extendsReferee);
            }
        }

        private static <T extends EObject> T copy(T eObject) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier(){

                public EObject copy(EObject eObject) {
                    EObject copy = super.copy(eObject);
                    eObject.eAdapters().forEach(adapter -> copy.eAdapters().add(adapter));
                    return copy;
                }
            };
            EObject result = copier.copy(eObject);
            copier.copyReferences();
            EObject t = result;
            return (T)t;
        }
    }

    private static class SuperTypeFixer
    extends TypesSwitch<Boolean> {
        private SuperTypeFixer() {
        }

        @Override
        public Boolean caseAnyType(AnyType anyType) {
            EClass eClass;
            AnyType superType = anyType.getType();
            if (anyType.isInlineType() && superType != null && anyType.eContainer() instanceof Property && (eClass = anyType.eClass()) != superType.eClass()) {
                AnyType newInlineType = (AnyType)EcoreUtil.create((EClass)superType.eClass());
                String name = anyType.getName() == null ? superType.getName() : anyType.getName();
                newInlineType.setName(name);
                newInlineType.setDefault(anyType.getDefault());
                newInlineType.setDescription(anyType.getDescription());
                newInlineType.getExamples().addAll(anyType.getExamples());
                newInlineType.getAnnotations().addAll(anyType.getAnnotations());
                newInlineType.setType(superType);
                Property property = (Property)anyType.eContainer();
                property.setType(newInlineType);
                EcoreUtil.replace((EObject)anyType, (EObject)newInlineType);
                return true;
            }
            return false;
        }
    }
}

